/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMSmladTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand4 = instruction.getOperands().get(3).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        String sourceRegister3 = registerOperand4.getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        OperandSize wd = OperandSize.WORD;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        String operand2 = environment.getNextVariableString();
        String operand2from15to0 = environment.getNextVariableString();
        String operand2from31to16 = environment.getNextVariableString();
        String overflow1 = environment.getNextVariableString();
        String overflow2 = environment.getNextVariableString();
        String product1 = environment.getNextVariableString();
        String product2 = environment.getNextVariableString();
        String registerRm15to0 = environment.getNextVariableString();
        String registerRm31to16 = environment.getNextVariableString();
        String tmpAddResult1 = environment.getNextVariableString();
        String tmpResult1 = environment.getNextVariableString();
        String tmpRotate1 = environment.getNextVariableString();
        String tmpRotate2 = environment.getNextVariableString();
        String trueproduct1 = environment.getNextVariableString();
        String trueproduct2 = environment.getNextVariableString();
        if (instruction.getMnemonic().contains("X")) {
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister2, bt2, String.valueOf(-16), dw, tmpRotate1));
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister2, bt2, String.valueOf(16), dw, tmpRotate2));
            instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpRotate1, dw, tmpRotate2, dw, operand2));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, operand2, dw, String.valueOf(0xFFFFFFFFL), dw, operand2));
        } else {
            instructions.add(ReilHelpers.createStr(baseOffset++, dw, sourceRegister2, dw, operand2));
        }
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, operand2, dw, String.valueOf(65535L), dw, operand2from15to0));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, operand2, dw, String.valueOf(-16L), dw, operand2from31to16));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister1, dw, String.valueOf(65535L), dw, registerRm15to0));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister1, dw, String.valueOf(-16L), dw, registerRm31to16));
        Helpers.signedMul(baseOffset, environment, instruction, instructions, wd, registerRm15to0, wd, operand2from15to0, dw, trueproduct1);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        Helpers.signedMul(baseOffset, environment, instruction, instructions, wd, registerRm31to16, wd, operand2from31to16, dw, trueproduct2);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, trueproduct1, dw, trueproduct2, qw, tmpAddResult1));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, sourceRegister3, qw, tmpAddResult1, qw, tmpResult1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpResult1, dw, String.valueOf(0xFFFFFFFFL), dw, targetRegister));
        Helpers.addOverflow(baseOffset, environment, instructions, dw, product1, dw, product2, qw, tmpAddResult1, overflow1, 16L);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        Helpers.addOverflow(baseOffset, environment, instructions, dw, sourceRegister3, qw, tmpAddResult1, qw, tmpResult1, overflow2, 16L);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createOr(baseOffset++, bt2, overflow1, bt2, overflow2, bt2, "Q"));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SMLAD");
        this.translateAll(environment, instruction, "SMLAD", instructions);
    }
}

