/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.reil.translators.arm.Processor;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMSaddsubxTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(final ITranslationEnvironment environment, final IInstruction instruction, final List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        final OperandSize bt2 = OperandSize.BYTE;
        final OperandSize wd = OperandSize.WORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        new Processor(){

            @Override
            protected String[] process(long offset, String[] firstTwo, String[] secondTwo) {
                String sum1 = environment.getNextVariableString();
                String diff1 = environment.getNextVariableString();
                String trueDiff1 = environment.getNextVariableString();
                String tmpVar1 = environment.getNextVariableString();
                String tmpVar2 = environment.getNextVariableString();
                long baseOffset = offset;
                instructions.add(ReilHelpers.createAdd(baseOffset++, dw, firstTwo[1], dw, secondTwo[0], dw, sum1));
                Helpers.signedSub(baseOffset, environment, instruction, instructions, secondTwo[1], firstTwo[0], diff1, trueDiff1);
                instructions.add(ReilHelpers.createXor(baseOffset++, dw, sum1, dw, String.valueOf(0xFFFFFFFFL), dw, tmpVar1));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar1, wd, String.valueOf(-31), bt2, "CPSR_GE_2"));
                instructions.add(ReilHelpers.createStr(baseOffset++, bt2, "CPSR_GE_2", bt2, "CPSR_GE_3"));
                instructions.add(ReilHelpers.createXor(baseOffset++, dw, diff1, dw, String.valueOf(0xFFFFFFFFL), dw, tmpVar2));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar2, wd, String.valueOf(-31), bt2, "CPSR_GE_0"));
                instructions.add(ReilHelpers.createStr(baseOffset++, bt2, "CPSR_GE_0", bt2, "CPSR_GE_1"));
                return new String[]{diff1, sum1};
            }
        }.generate(environment, baseOffset, 16, sourceRegister1, sourceRegister2, targetRegister, instructions);
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        if (instruction.getMnemonic().startsWith("SASX")) {
            TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SASX");
            this.translateAll(environment, instruction, "SASX", instructions);
        } else {
            TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SADDSUBX");
            this.translateAll(environment, instruction, "SADDSUBX", instructions);
        }
    }
}

