/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.reil.translators.arm.Processor;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMQsub8Translator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(final ITranslationEnvironment environment, final IInstruction instruction, final List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        String subOperation = "SUB";
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        new Processor(){

            @Override
            protected String[] process(long offset, String[] firstFour, String[] secondFour) {
                String diff1 = environment.getNextVariableString();
                String diff2 = environment.getNextVariableString();
                String diff3 = environment.getNextVariableString();
                String diff4 = environment.getNextVariableString();
                String trueDiff1 = environment.getNextVariableString();
                String trueDiff2 = environment.getNextVariableString();
                String trueDiff3 = environment.getNextVariableString();
                String trueDiff4 = environment.getNextVariableString();
                long baseOffset = offset;
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, firstFour[0], dw, secondFour[0], dw, trueDiff1));
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, firstFour[1], dw, secondFour[1], dw, trueDiff2));
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, firstFour[2], dw, secondFour[2], dw, trueDiff3));
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, firstFour[3], dw, secondFour[3], dw, trueDiff4));
                Helpers.signedSat(baseOffset, environment, instruction, instructions, dw, firstFour[0], dw, secondFour[0], dw, trueDiff1, "SUB", diff1, 8L, "");
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.signedSat(baseOffset, environment, instruction, instructions, dw, firstFour[1], dw, secondFour[1], dw, trueDiff2, "SUB", diff2, 8L, "");
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.signedSat(baseOffset, environment, instruction, instructions, dw, firstFour[2], dw, secondFour[2], dw, trueDiff3, "SUB", diff3, 8L, "");
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.signedSat(baseOffset, environment, instruction, instructions, dw, firstFour[3], dw, secondFour[3], dw, trueDiff4, "SUB", diff4, 8L, "");
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                return new String[]{diff1, diff2, diff3, diff4};
            }
        }.generate(environment, baseOffset, 8, sourceRegister1, sourceRegister2, targetRegister, instructions);
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "QSUB8");
        this.translateAll(environment, instruction, "QSUB8", instructions);
    }
}

