/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMMsrTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode sourceOperand = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        String sourceRegister = sourceOperand.getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize dw = OperandSize.DWORD;
        String tmpZ = environment.getNextVariableString();
        String tmpC = environment.getNextVariableString();
        String tmpV = environment.getNextVariableString();
        String tmpQ = environment.getNextVariableString();
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister, dw, String.valueOf(-31), bt2, "N"));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister, dw, String.valueOf(-30), bt2, tmpZ));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpZ, bt2, String.valueOf(1L), bt2, "Z"));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister, dw, String.valueOf(-29), bt2, tmpC));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpC, bt2, String.valueOf(1L), bt2, "C"));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister, dw, String.valueOf(-28), bt2, tmpV));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpV, bt2, String.valueOf(1L), bt2, "C"));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister, dw, String.valueOf(-29), bt2, tmpQ));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpQ, bt2, String.valueOf(1L), bt2, "C"));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "MSR");
        this.translateAll(environment, instruction, "MSR", instructions);
    }
}

