/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMMrsTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String tmpVar1 = environment.getNextVariableString();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, "N", dw, String.valueOf(1L), dw, tmpVar1));
        instructions.add(ReilHelpers.createOr(baseOffset++, bt2, "Z", dw, tmpVar1, dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar1, dw, String.valueOf(1L), dw, tmpVar1));
        instructions.add(ReilHelpers.createOr(baseOffset++, bt2, "C", dw, tmpVar1, dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar1, dw, String.valueOf(1L), dw, tmpVar1));
        instructions.add(ReilHelpers.createOr(baseOffset++, bt2, "V", dw, tmpVar1, dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar1, dw, String.valueOf(1L), dw, tmpVar1));
        instructions.add(ReilHelpers.createOr(baseOffset++, bt2, "Q", dw, tmpVar1, dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar1, dw, String.valueOf(3L), dw, tmpVar1));
        instructions.add(ReilHelpers.createOr(baseOffset++, bt2, "J", dw, tmpVar1, dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar1, dw, String.valueOf(8L), dw, tmpVar1));
        instructions.add(ReilHelpers.createOr(baseOffset++, bt2, "CPSR_GE", dw, tmpVar1, dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar1, dw, String.valueOf(7L), dw, tmpVar1));
        instructions.add(ReilHelpers.createOr(baseOffset++, bt2, "E", dw, tmpVar1, dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar1, dw, String.valueOf(1L), dw, tmpVar1));
        instructions.add(ReilHelpers.createOr(baseOffset++, bt2, "A", dw, tmpVar1, dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar1, dw, String.valueOf(1L), dw, tmpVar1));
        instructions.add(ReilHelpers.createOr(baseOffset++, bt2, "I", dw, tmpVar1, dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar1, dw, String.valueOf(1L), dw, tmpVar1));
        instructions.add(ReilHelpers.createOr(baseOffset++, bt2, "F", dw, tmpVar1, dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar1, dw, String.valueOf(1L), dw, tmpVar1));
        instructions.add(ReilHelpers.createOr(baseOffset++, bt2, "T", dw, tmpVar1, dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar1, dw, String.valueOf(5L), dw, tmpVar1));
        instructions.add(ReilHelpers.createOr(baseOffset++, bt2, "CPSR_M", dw, tmpVar1, dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar1, dw, String.valueOf(5L), dw, tmpVar1));
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, tmpVar1, dw, targetRegister));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "MRS");
        this.translateAll(environment, instruction, "MRS", instructions);
    }
}

