/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.AddressingModeTwoGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class ARMLdrtTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode rootNode = instruction.getOperands().get(1).getRootNode();
        String registerNodeValue = registerOperand1.getValue();
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        OperandSize bt2 = OperandSize.BYTE;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        Pair<String, String> resultPair = AddressingModeTwoGenerator.generate(baseOffset, environment, instruction, instructions, rootNode);
        String tmpAddress = resultPair.first();
        String negRotateVal = environment.getNextVariableString();
        String posRotateVal = environment.getNextVariableString();
        String rotateVal1 = environment.getNextVariableString();
        String rotateVal2 = environment.getNextVariableString();
        String rotResult1 = environment.getNextVariableString();
        String rotResult2 = environment.getNextVariableString();
        String tmpData1 = environment.getNextVariableString();
        String tmpRotResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createLdm(baseOffset++, dw, tmpAddress, dw, tmpData1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpAddress, bt2, String.valueOf(3L), bt2, rotateVal1));
        instructions.add(ReilHelpers.createMul(baseOffset++, bt2, rotateVal1, bt2, String.valueOf(8), wd, rotateVal2));
        instructions.add(ReilHelpers.createSub(baseOffset++, wd, String.valueOf(0), wd, rotateVal2, dw, negRotateVal));
        instructions.add(ReilHelpers.createSub(baseOffset++, wd, String.valueOf(32), wd, rotateVal2, dw, posRotateVal));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpData1, dw, negRotateVal, dw, rotResult1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpData1, dw, posRotateVal, dw, rotResult2));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, rotResult1, dw, rotResult2, dw, tmpRotResult));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpRotResult, dw, String.valueOf(0xFFFFFFFFL), dw, registerNodeValue));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "LDR");
        this.translateAll(environment, instruction, "LDR", instructions);
    }
}

