/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.AddressingModeOneGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class ARMCmpTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode shifter = instruction.getOperands().get(1).getRootNode();
        String sourceRegister = registerOperand1.getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String tmpVar1 = environment.getNextVariableString();
        String aluOut = environment.getNextVariableString();
        String tmpBorrow = environment.getNextVariableString();
        Pair<String, String> shifterPair = AddressingModeOneGenerator.generate(baseOffset, environment, instruction, instructions, shifter);
        baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String shifterOperand = shifterPair.first();
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, sourceRegister, dw, shifterOperand, qw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar1, dw, String.valueOf(0xFFFFFFFFL), dw, aluOut));
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        String msbVar1 = environment.getNextVariableString();
        String msbVar2 = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBsh(baseOffset++, qw, tmpVar1, dw, String.valueOf(-31L), bt2, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar3, bt2, String.valueOf(1L), bt2, "N"));
        instructions.add(ReilHelpers.createBisz(baseOffset++, dw, aluOut, bt2, "Z"));
        instructions.add(ReilHelpers.createBsh(baseOffset++, qw, tmpVar1, wd, String.valueOf(-32L), bt2, tmpVar4));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar4, bt2, String.valueOf(1L), bt2, tmpBorrow));
        instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, tmpBorrow, bt2, "C"));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, shifterOperand, wd, String.valueOf(-31L), bt2, msbVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister, wd, String.valueOf(-31L), bt2, msbVar2));
        instructions.add(ReilHelpers.createXor(baseOffset++, bt2, msbVar1, bt2, msbVar2, bt2, tmpVar4));
        instructions.add(ReilHelpers.createXor(baseOffset++, bt2, msbVar1, bt2, "N", bt2, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar4, bt2, tmpVar3, bt2, "V"));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "CMP");
        this.translateAll(environment, instruction, "CMP", instructions);
    }
}

