/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMBxTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        String sourceRegister1 = registerOperand1.getValue();
        String[] meta_false = new String[]{"isCall", "false"};
        String[] meta_true = new String[]{"isCall", "true"};
        OperandSize dw = OperandSize.DWORD;
        OperandSize bt2 = OperandSize.BYTE;
        String jumpOperand = environment.getNextVariableString();
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister1, bt2, String.valueOf(1), bt2, "T"));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister1, dw, String.valueOf(0xFFFFFFFEL), dw, jumpOperand));
        if (sourceRegister1.equalsIgnoreCase("LR")) {
            instructions.add(ReilHelpers.createJcc(baseOffset++, bt2, String.valueOf(1), dw, jumpOperand, meta_false));
        } else {
            instructions.add(ReilHelpers.createJcc(baseOffset++, bt2, String.valueOf(1), dw, jumpOperand, meta_true));
        }
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "BX");
        this.translateAll(environment, instruction, "BX", instructions);
    }
}

