/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.StandardEnvironment;
import com.google.security.zynamics.reil.translators.arm.ConditionGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ARMBaseTranslator
implements IInstructionTranslator {
    private void translateCondition(ITranslationEnvironment environment, IInstruction instruction, String prefix, List<ReilInstruction> instructions, int nopIndex) throws InternalTranslationException {
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        Pattern condPattern = Pattern.compile(String.valueOf(prefix).concat("(AL|CC|LO|CS|HS|EQ|GE|GT|HI|LE|LS|LT|MI|NE|NV|PL|VC|VS).{0,2}$"));
        Matcher condMatcher = condPattern.matcher(instruction.getMnemonic());
        if (condMatcher.matches()) {
            String jmpGoal = String.format("%d.%d", instruction.getAddress().toLong(), nopIndex);
            ConditionGenerator.generate(baseOffset, environment, instruction, instructions, condMatcher.group(1), jmpGoal);
        }
    }

    protected int countConditionInstructions(IInstruction instruction, String prefix) throws InternalTranslationException {
        ArrayList<ReilInstruction> instructions = new ArrayList<ReilInstruction>();
        this.translateCondition(new StandardEnvironment(), instruction, prefix, instructions, 0);
        return instructions.size();
    }

    protected int countInnerInstructions(IInstruction instruction) throws InternalTranslationException {
        ArrayList<ReilInstruction> instructions = new ArrayList<ReilInstruction>();
        this.translateCore(new StandardEnvironment(), instruction, instructions);
        return instructions.size();
    }

    protected void translateAll(ITranslationEnvironment environment, IInstruction instruction, String prefix, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        int conditionInstructions = this.countConditionInstructions(instruction, prefix);
        int totalInstructions = conditionInstructions + this.countInnerInstructions(instruction);
        this.translateCondition(environment, instruction, prefix, instructions, totalInstructions);
        this.translateCore(environment, instruction, instructions);
        if (conditionInstructions != 0) {
            instructions.add(ReilHelpers.createNop(baseOffset + (long)totalInstructions));
        }
    }

    protected abstract void translateCore(ITranslationEnvironment var1, IInstruction var2, List<ReilInstruction> var3) throws InternalTranslationException;
}

