/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.security.zynamics.reil.ReilBlock;
import com.google.security.zynamics.reil.ReilEdge;
import com.google.security.zynamics.reil.ReilFunction;
import com.google.security.zynamics.reil.ReilGraph;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.ReilProgram;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.ITranslationExtension;
import com.google.security.zynamics.reil.translators.ITranslator;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.ReilGraphGenerator;
import com.google.security.zynamics.reil.translators.StandardEnvironment;
import com.google.security.zynamics.reil.translators.arm.TranslatorARM;
import com.google.security.zynamics.reil.translators.mips.TranslatorMIPS;
import com.google.security.zynamics.reil.translators.ppc.TranslatorPPC;
import com.google.security.zynamics.reil.translators.reil.TranslatorREIL;
import com.google.security.zynamics.reil.translators.x86.TranslatorX86;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.IBlockContainer;
import com.google.security.zynamics.zylib.disassembly.ICodeContainer;
import com.google.security.zynamics.zylib.disassembly.ICodeEdge;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import com.google.security.zynamics.zylib.types.common.ICollectionMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ReilTranslator<InstructionType extends IInstruction> {
    private final Map<String, ITranslator<InstructionType>> m_translators = new HashMap<String, ITranslator<InstructionType>>();

    public ReilTranslator() {
        this.m_translators.put("X86-32", new TranslatorX86());
        this.m_translators.put("ARM-32", new TranslatorARM());
        this.m_translators.put("POWERPC-32", new TranslatorPPC());
        this.m_translators.put("REIL", new TranslatorREIL());
        this.m_translators.put("MIPS-32", new TranslatorMIPS());
    }

    private static Collection<IAddress> getBlockAddresses(IBlockContainer<?> function) {
        return CollectionHelpers.map(function.getBasicBlocks(), new ICollectionMapper<ICodeContainer<?>, IAddress>(){

            private boolean isDelayedBranch(ReilInstruction instruction) {
                return instruction.getMnemonic().equals("jcc") && ReilHelpers.isDelayedBranch(instruction);
            }

            @Override
            public IAddress map(ICodeContainer<?> block) {
                IInstruction lastInstruction = Iterables.getFirst(block.getInstructions(), null);
                ReilTranslator<IInstruction> translator = new ReilTranslator<IInstruction>();
                try {
                    ReilGraph reilGraph = translator.translate((ITranslationEnvironment)new StandardEnvironment(), lastInstruction);
                    ReilBlock lastNode = (ReilBlock)reilGraph.getNodes().get(reilGraph.getNodes().size() - 1);
                    ReilInstruction lastReilInstruction = Iterables.getLast(lastNode.getInstructions());
                    if (this.isDelayedBranch(lastReilInstruction)) {
                        return ReilHelpers.toReilAddress(((IInstruction)Iterables.get(block.getInstructions(), 1)).getAddress());
                    }
                    return ReilHelpers.toReilAddress(block.getAddress());
                }
                catch (InternalTranslationException e2) {
                    return ReilHelpers.toReilAddress(block.getAddress());
                }
            }
        });
    }

    private static IInstruction getFirstInstruction(ICodeContainer<?> container) {
        return Iterables.getFirst(container.getInstructions(), null);
    }

    private static ReilInstruction getFirstInstruction(List<ReilInstruction> list) {
        return list.get(0);
    }

    private static IInstruction getLastInstruction(ICodeContainer<?> container) {
        return (IInstruction)Iterables.getLast(container.getInstructions());
    }

    private static ReilInstruction getLastInstruction(List<ReilInstruction> list) {
        return list.get(list.size() - 1);
    }

    private static ReilBlock getNode(ReilInstruction instruction, List<ReilBlock> blocks) {
        for (ReilBlock block : blocks) {
            for (ReilInstruction reilInstruction : block) {
                if (instruction != reilInstruction) continue;
                return block;
            }
        }
        throw new IllegalStateException(String.format("Error: Unknown block (Instruction '%s' not found)", instruction));
    }

    private static void handleDelayedTrueBranches(List<ReilBlock> nodes, List<ReilEdge> edges, List<List<ReilInstruction>> delayedTrueBranches) {
        for (List<ReilInstruction> lastReil : delayedTrueBranches) {
            ReilInstruction lastReilInstruction = lastReil.get(lastReil.size() - 1);
            for (ReilBlock node : nodes) {
                Iterable<ReilInstruction> nodeInstructions = node.getInstructions();
                if (Iterables.getLast(nodeInstructions) != lastReilInstruction) continue;
                ReilEdge incomingEdge = node.getIncomingEdges().get(0);
                ReilBlock parentNode = incomingEdge.getSource();
                edges.remove(incomingEdge);
                boolean first = true;
                for (ReilEdge outgoingEdge : node.getOutgoingEdges()) {
                    if (first) {
                        first = false;
                        ReilEdge newEdge = new ReilEdge(parentNode, node, EdgeType.JUMP_CONDITIONAL_TRUE);
                        ReilBlock.link(parentNode, node, newEdge);
                        edges.add(newEdge);
                        ReilEdge newEdge2 = new ReilEdge(parentNode, outgoingEdge.getTarget(), EdgeType.JUMP_CONDITIONAL_FALSE);
                        ReilBlock.link(parentNode, outgoingEdge.getTarget(), newEdge2);
                        edges.add(newEdge2);
                    } else {
                        ReilEdge newEdge2 = new ReilEdge(node, outgoingEdge.getTarget(), outgoingEdge.getType());
                        ReilBlock.link(node, outgoingEdge.getTarget(), newEdge2);
                        edges.add(newEdge2);
                    }
                    edges.remove(outgoingEdge);
                    ReilBlock.unlink(outgoingEdge.getSource(), outgoingEdge.getTarget(), outgoingEdge);
                }
            }
        }
    }

    private static boolean hasEdge(List<ReilBlock> nodes, ReilBlock node, ReilInstruction instruction) {
        for (ReilBlock block : nodes) {
            if (!ReilTranslator.shareOriginalInstruction(node, block) || !ReilTranslator.hasEdge(block, instruction)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasEdge(ReilBlock node, final ReilInstruction instruction) {
        return CollectionHelpers.any(node.getOutgoingEdges(), new ICollectionFilter<ReilEdge>(){

            @Override
            public boolean qualifies(ReilEdge outgoingEdge) {
                return ReilTranslator.getFirstInstruction(outgoingEdge.getTarget()) == instruction;
            }
        });
    }

    private static void insertNativeEdge(List<ReilBlock> nodes, List<ReilEdge> edges, ICodeEdge<?> nativeEdge, ReilInstruction sourceReilInstruction, ReilInstruction targetReilInstruction) {
        for (ReilBlock node : nodes) {
            if (sourceReilInstruction != ReilTranslator.getLastInstruction(node) || ReilTranslator.hasEdge(nodes, node, targetReilInstruction)) continue;
            EdgeType edgeType = ReilHelpers.isJump(sourceReilInstruction) ? nativeEdge.getType() : EdgeType.JUMP_UNCONDITIONAL;
            ReilBlock targetNode = ReilTranslator.getNode(targetReilInstruction, nodes);
            ReilEdge newEdge = new ReilEdge(node, targetNode, edgeType);
            ReilBlock.link(node, targetNode, newEdge);
            edges.add(newEdge);
        }
    }

    private static void insertNativeEdges(List<? extends ICodeEdge<?>> nativeEdges, List<ReilBlock> nodes, List<ReilEdge> edges, Map<IInstruction, ReilInstruction> firstMap, Map<IInstruction, ReilInstruction> lastMap) {
        for (ICodeEdge<?> nativeEdge : nativeEdges) {
            Object source = nativeEdge.getSource();
            Object target = nativeEdge.getTarget();
            if (!(source instanceof ICodeContainer) || !(target instanceof ICodeContainer)) continue;
            ICodeContainer sourceCodeNode = (ICodeContainer)source;
            ICodeContainer targetCodeNode = (ICodeContainer)target;
            IInstruction sourceInstruction = ReilTranslator.getLastInstruction(sourceCodeNode);
            IInstruction targetInstruction = ReilTranslator.getFirstInstruction(targetCodeNode);
            ReilInstruction sourceReilInstruction = lastMap.get(sourceInstruction);
            ReilInstruction targetReilInstruction = firstMap.get(targetInstruction);
            ReilTranslator.insertNativeEdge(nodes, edges, nativeEdge, sourceReilInstruction, targetReilInstruction);
        }
    }

    private static boolean isInlineSource(ICodeContainer<?> container) {
        return container.getOutgoingEdges().size() == 1 && container.getOutgoingEdges().get(0).getType() == EdgeType.ENTER_INLINED_FUNCTION;
    }

    private static boolean shareOriginalInstruction(ReilBlock node, ReilBlock block) {
        return (ReilTranslator.getLastInstruction(block).getAddress().toLong() & 0xFFFFFFFFFFFFFF00L) == (ReilTranslator.getLastInstruction(node).getAddress().toLong() & 0xFFFFFFFFFFFFFF00L);
    }

    private List<ReilInstruction> getReilInstructions(IInstruction instruction, ArrayList<ReilInstruction> instructions) {
        ArrayList<ReilInstruction> result = new ArrayList<ReilInstruction>();
        for (ReilInstruction reilInstruction : instructions) {
            if (!ReilHelpers.toNativeAddress(reilInstruction.getAddress()).equals(instruction.getAddress())) continue;
            result.add(reilInstruction);
        }
        return result;
    }

    public ReilFunction translate(ITranslationEnvironment environment, IBlockContainer<InstructionType> function) throws InternalTranslationException {
        return this.translate(environment, function, (List<ITranslationExtension<InstructionType>>)new ArrayList<ITranslationExtension<InstructionType>>());
    }

    public ReilFunction translate(ITranslationEnvironment environment, IBlockContainer<InstructionType> function, List<ITranslationExtension<InstructionType>> extensions) throws InternalTranslationException {
        LinkedHashMap<ICodeContainer<InstructionType>, ArrayList<ReilInstruction>> instructionMap = new LinkedHashMap<ICodeContainer<InstructionType>, ArrayList<ReilInstruction>>();
        HashMap<IInstruction, ReilInstruction> firstMap = new HashMap<IInstruction, ReilInstruction>();
        HashMap<IInstruction, ReilInstruction> lastMap = new HashMap<IInstruction, ReilInstruction>();
        ArrayList<List<ReilInstruction>> delayedTrueBranches = new ArrayList<List<ReilInstruction>>();
        for (ICodeContainer<InstructionType> block : function.getBasicBlocks()) {
            List<ReilInstruction> lastReil;
            IInstruction lastInstruction;
            Iterable<InstructionType> blockInstructions = block.getInstructions();
            IInstruction lastBlockInstruction = (IInstruction)Iterables.getLast(blockInstructions);
            boolean endsWithInlining = ReilTranslator.isInlineSource(block);
            ArrayList<ReilInstruction> instructions = new ArrayList<ReilInstruction>();
            instructionMap.put(block, instructions);
            for (IInstruction instruction : blockInstructions) {
                environment.nextInstruction();
                ITranslator<IInstruction> translator = this.m_translators.get(instruction.getArchitecture().toUpperCase());
                if (translator == null) {
                    String string2 = String.valueOf(instruction.getArchitecture());
                    throw new InternalTranslationException(string2.length() != 0 ? "Could not translate instruction from unknown architecture ".concat(string2) : new String("Could not translate instruction from unknown architecture "));
                }
                try {
                    ReilInstruction lastInstruction2;
                    List<ReilInstruction> result = translator.translate(environment, instruction, extensions);
                    instructions.addAll(result);
                    if (endsWithInlining && instruction == lastBlockInstruction && (lastInstruction2 = instructions.get(instructions.size() - 1)).getMnemonic().equals("jcc") && lastInstruction2.getMetaData().containsKey("isCall")) {
                        instructions.remove(instructions.size() - 1);
                        result.remove(result.size() - 1);
                    }
                    firstMap.put(instruction, ReilTranslator.getFirstInstruction(result));
                    lastMap.put(instruction, ReilTranslator.getLastInstruction(result));
                }
                catch (InternalTranslationException exception) {
                    exception.setInstruction(instruction);
                    throw exception;
                }
            }
            IInstruction secondLastInstruction = Iterables.size(block.getInstructions()) > 2 ? (IInstruction)Iterables.get(block.getInstructions(), Iterables.size(block.getInstructions()) - 2, null) : null;
            if (secondLastInstruction == null) continue;
            List<ReilInstruction> secondLastReil = this.getReilInstructions(secondLastInstruction, instructions);
            if (ReilHelpers.isDelayedBranch(secondLastReil.get(secondLastReil.size() - 1))) {
                lastInstruction = ReilTranslator.getLastInstruction(block);
                lastReil = this.getReilInstructions(lastInstruction, instructions);
                if (!secondLastReil.get(secondLastReil.size() - 1).getMnemonic().equals("jcc")) continue;
                instructions.removeAll(lastReil);
                instructions.addAll(instructions.size() - 1, lastReil);
                continue;
            }
            if (!ReilHelpers.isDelayedTrueBranch(secondLastReil.get(secondLastReil.size() - 1))) continue;
            lastInstruction = ReilTranslator.getLastInstruction(block);
            lastReil = this.getReilInstructions(lastInstruction, instructions);
            delayedTrueBranches.add(lastReil);
        }
        Collection<IAddress> nativeJumpTargets = ReilTranslator.getBlockAddresses(function);
        Pair<List<ReilBlock>, List<ReilEdge>> pair = ReilGraphGenerator.createGraphElements(instructionMap.values(), nativeJumpTargets);
        List<ReilBlock> nodes = pair.first();
        List<ReilEdge> edges = pair.second();
        ReilTranslator.insertNativeEdges(function.getBasicBlockEdges(), nodes, edges, firstMap, lastMap);
        ReilTranslator.handleDelayedTrueBranches(nodes, edges, delayedTrueBranches);
        String string3 = String.valueOf(function.getName());
        return new ReilFunction(string3.length() != 0 ? "REIL - ".concat(string3) : new String("REIL - "), new ReilGraph(nodes, edges));
    }

    public ReilGraph translate(ITranslationEnvironment environment, ICodeContainer<InstructionType> block) throws InternalTranslationException {
        return this.translate(environment, (InstructionType)block, (List<ITranslationExtension<InstructionType>>)new ArrayList<ITranslationExtension<InstructionType>>());
    }

    public ReilGraph translate(ITranslationEnvironment environment, ICodeContainer<InstructionType> block, List<ITranslationExtension<InstructionType>> extensions) throws InternalTranslationException {
        ArrayList<ReilInstruction> instructions = new ArrayList<ReilInstruction>();
        for (IInstruction instruction : block.getInstructions()) {
            environment.nextInstruction();
            ITranslator<IInstruction> translator = this.m_translators.get(instruction.getArchitecture().toUpperCase());
            if (translator == null) {
                String string2 = String.valueOf(instruction.getArchitecture());
                throw new InternalTranslationException(string2.length() != 0 ? "Could not translate instruction from unknown architecture ".concat(string2) : new String("Could not translate instruction from unknown architecture "));
            }
            try {
                instructions.addAll(translator.translate(environment, instruction, extensions));
            }
            catch (InternalTranslationException exception) {
                exception.setInstruction(instruction);
                throw exception;
            }
        }
        LinkedHashMap<ICodeContainer<InstructionType>, ArrayList<ReilInstruction>> instructionMap = new LinkedHashMap<ICodeContainer<InstructionType>, ArrayList<ReilInstruction>>();
        instructionMap.put(block, instructions);
        return ReilGraphGenerator.createGraph(instructionMap.values(), new ArrayList<IAddress>());
    }

    public ReilGraph translate(ITranslationEnvironment environment, InstructionType instruction) throws InternalTranslationException {
        return this.translate(environment, instruction, new ArrayList<ITranslationExtension<InstructionType>>());
    }

    public ReilGraph translate(ITranslationEnvironment environment, InstructionType instruction, List<ITranslationExtension<InstructionType>> extensions) throws InternalTranslationException {
        ArrayList<ReilInstruction> instructions = new ArrayList<ReilInstruction>();
        environment.nextInstruction();
        ITranslator<InstructionType> translator = this.m_translators.get(instruction.getArchitecture().toUpperCase());
        if (translator == null) {
            String string2 = String.valueOf(instruction.getArchitecture());
            throw new InternalTranslationException(string2.length() != 0 ? "Could not translate instruction from unknown architecture ".concat(string2) : new String("Could not translate instruction from unknown architecture "));
        }
        try {
            instructions.addAll(translator.translate(environment, instruction, extensions));
        }
        catch (InternalTranslationException exception) {
            exception.setInstruction((IInstruction)instruction);
            throw exception;
        }
        LinkedHashMap instructionMap = new LinkedHashMap();
        InstructionContainer container = new InstructionContainer((IInstruction)instruction, null);
        instructionMap.put(container, instructions);
        return ReilGraphGenerator.createGraph(instructionMap.values(), new ArrayList<IAddress>());
    }

    public ReilProgram<InstructionType> translate(ITranslationEnvironment environment, List<? extends IBlockContainer<InstructionType>> functions) throws InternalTranslationException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        ReilProgram<InstructionType> program = new ReilProgram<InstructionType>();
        for (IBlockContainer<InstructionType> function : functions) {
            program.addFunction(function, this.translate(environment, function));
        }
        return program;
    }

    private static class InstructionContainer<InstructionType extends IInstruction>
    implements ICodeContainer<InstructionType> {
        private final InstructionType m_instruction;

        private InstructionContainer(InstructionType instruction) {
            this.m_instruction = instruction;
        }

        @Override
        public IAddress getAddress() {
            return this.m_instruction.getAddress();
        }

        @Override
        public Iterable<InstructionType> getInstructions() {
            return Lists.newArrayList(this.m_instruction);
        }

        @Override
        public InstructionType getLastInstruction() {
            return this.m_instruction;
        }

        @Override
        public List<? extends ICodeEdge<?>> getOutgoingEdges() {
            return new ArrayList();
        }

        @Override
        public boolean hasInstruction(InstructionType instruction) {
            return this.m_instruction == instruction;
        }

        /* synthetic */ InstructionContainer(IInstruction x0, 1 x1) {
            this(x0);
        }
    }
}

