/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators;

import com.google.common.collect.Iterables;
import com.google.security.zynamics.reil.OperandType;
import com.google.security.zynamics.reil.ReilBlock;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Convert;
import com.google.security.zynamics.zylib.general.Triple;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public final class BasicBlockGenerator {
    private List<ReilInstruction> currentBlock = new ArrayList<ReilInstruction>();
    private final List<ReilBlock> blocks = new ArrayList<ReilBlock>();
    private final ArrayList<Triple<ReilBlock, IAddress, EdgeType>> edgepairs = new ArrayList();

    public BasicBlockGenerator(Collection<List<ReilInstruction>> instructionList, Collection<IAddress> nativeJumpTargets) {
        for (List<ReilInstruction> instructions : instructionList) {
            HashSet<IAddress> jumpTargets = BasicBlockGenerator.fillJumpTargets(instructions);
            jumpTargets.addAll(nativeJumpTargets);
            ReilInstruction lastInstruction = Iterables.getLast(instructions);
            for (ReilInstruction reilInstruction : instructions) {
                this.addInstruction(reilInstruction, jumpTargets, lastInstruction);
            }
            if (this.currentBlock.size() == 0) continue;
            ReilBlock reilBlock = new ReilBlock(this.currentBlock);
            this.blocks.add(reilBlock);
            this.currentBlock = new ArrayList<ReilInstruction>();
        }
    }

    private static HashSet<IAddress> fillJumpTargets(Collection<ReilInstruction> reilInstructions) {
        HashSet<IAddress> jumpTargets = new HashSet<IAddress>();
        for (ReilInstruction reilInstruction : reilInstructions) {
            if (!reilInstruction.getMnemonic().equals("jcc")) continue;
            String jumpTarget = reilInstruction.getThirdOperand().getValue();
            if (Convert.isDecString(jumpTarget)) {
                jumpTargets.add(BasicBlockGenerator.toReilAddress(jumpTarget));
                continue;
            }
            if (reilInstruction.getThirdOperand().getType() != OperandType.SUB_ADDRESS) continue;
            jumpTargets.add(BasicBlockGenerator.toReilAddress(jumpTarget.split("\\.")));
        }
        return jumpTargets;
    }

    private static IAddress toReilAddress(String addressString) {
        return ReilHelpers.toReilAddress(new CAddress(Long.valueOf(addressString)));
    }

    private static IAddress toReilAddress(String[] parts) {
        return new CAddress(BasicBlockGenerator.toReilAddress(parts[0]).toLong() + Long.valueOf(parts[1]));
    }

    private void addInstruction(ReilInstruction reilInstruction, HashSet<IAddress> jumpTargets, ReilInstruction lastInstruction) {
        ReilBlock reilBlock;
        if (jumpTargets.contains(reilInstruction.getAddress()) && this.currentBlock.size() != 0) {
            reilBlock = new ReilBlock(this.currentBlock);
            this.blocks.add(reilBlock);
            this.edgepairs.add(new Triple<ReilBlock, IAddress, EdgeType>(reilBlock, reilInstruction.getAddress(), EdgeType.JUMP_UNCONDITIONAL));
            this.currentBlock = new ArrayList<ReilInstruction>();
        }
        this.currentBlock.add(reilInstruction);
        if (reilInstruction.getMnemonic().equals("jcc") && (ReilHelpers.isDelayedBranch(reilInstruction) || reilInstruction != lastInstruction)) {
            reilBlock = new ReilBlock(this.currentBlock);
            this.blocks.add(reilBlock);
            this.currentBlock = new ArrayList<ReilInstruction>();
            String jumpTarget = reilInstruction.getThirdOperand().getValue();
            if (ReilHelpers.isConditionalJump(reilInstruction)) {
                this.edgepairs.add(new Triple<ReilBlock, Object, EdgeType>(reilBlock, null, EdgeType.JUMP_CONDITIONAL_FALSE));
                if (Convert.isDecString(jumpTarget)) {
                    this.edgepairs.add(new Triple<ReilBlock, IAddress, EdgeType>(reilBlock, BasicBlockGenerator.toReilAddress(jumpTarget), EdgeType.JUMP_CONDITIONAL_TRUE));
                } else if (reilInstruction.getThirdOperand().getType() == OperandType.SUB_ADDRESS) {
                    String[] parts = jumpTarget.split("\\.");
                    this.edgepairs.add(new Triple<ReilBlock, IAddress, EdgeType>(reilBlock, BasicBlockGenerator.toReilAddress(parts), EdgeType.JUMP_CONDITIONAL_TRUE));
                }
            } else if (ReilHelpers.isFunctionCall(reilInstruction)) {
                this.edgepairs.add(new Triple<ReilBlock, Object, EdgeType>(reilBlock, null, EdgeType.JUMP_UNCONDITIONAL));
            } else if (Convert.isDecString(jumpTarget)) {
                this.edgepairs.add(new Triple<ReilBlock, IAddress, EdgeType>(reilBlock, BasicBlockGenerator.toReilAddress(jumpTarget), EdgeType.JUMP_UNCONDITIONAL));
            } else if (reilInstruction.getThirdOperand().getType() == OperandType.SUB_ADDRESS) {
                String[] parts = jumpTarget.split("\\.");
                this.edgepairs.add(new Triple<ReilBlock, IAddress, EdgeType>(reilBlock, BasicBlockGenerator.toReilAddress(parts), EdgeType.JUMP_UNCONDITIONAL));
            }
        }
    }

    public List<ReilBlock> getBlocks() {
        return new ArrayList<ReilBlock>(this.blocks);
    }

    public ArrayList<Triple<ReilBlock, IAddress, EdgeType>> getEdges() {
        return new ArrayList<Triple<ReilBlock, IAddress, EdgeType>>(this.edgepairs);
    }
}

