/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.interpreter;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.interpreter.Endianness;
import com.google.security.zynamics.zylib.general.memmanager.Memory;

public class ReilMemory {
    private final Memory memory = new Memory();
    final Endianness endianness;

    public ReilMemory(Endianness endianness) {
        this.endianness = Preconditions.checkNotNull(endianness, "Error: Argument endianness can't be null");
    }

    private byte[] getData(long value, int length) {
        if (this.endianness == Endianness.LITTLE_ENDIAN) {
            return this.getDataLittle(value, length);
        }
        return this.getDataBig(value, length);
    }

    private byte[] getDataBig(long value, int length) {
        if (length == 1) {
            return new byte[]{(byte)(value & 0xFFL)};
        }
        if (length == 2) {
            return new byte[]{(byte)((value & 0xFF00L) >> 8), (byte)(value & 0xFFL)};
        }
        if (length == 4) {
            return new byte[]{(byte)((value & 0xFFFFFFFFFF000000L) >> 24), (byte)((value & 0xFF0000L) >> 16), (byte)((value & 0xFF00L) >> 8), (byte)(value & 0xFFL)};
        }
        throw new IllegalArgumentException("Error: Invalid data length");
    }

    private byte[] getDataLittle(long value, int length) {
        if (length == 1) {
            return new byte[]{(byte)(value & 0xFFL)};
        }
        if (length == 2) {
            return new byte[]{(byte)(value & 0xFFL), (byte)((value & 0xFF00L) >> 8)};
        }
        if (length == 4) {
            return new byte[]{(byte)(value & 0xFFL), (byte)((value & 0xFF00L) >> 8), (byte)((value & 0xFF0000L) >> 16), (byte)((value & 0xFFFFFFFFFF000000L) >> 24)};
        }
        throw new IllegalArgumentException("Error: Invalid data length");
    }

    private long loadBig(byte[] data) {
        switch (data.length) {
            case 1: {
                return data[0] & 0xFF;
            }
            case 2: {
                return (data[1] & 0xFF) + (data[0] & 0xFF) * 256;
            }
            case 4: {
                return (data[3] & 0xFF) + (data[2] & 0xFF) * 256 + (data[1] & 0xFF) * 256 * 256 + (data[0] & 0xFF) * 256 * 256 * 256;
            }
        }
        throw new IllegalArgumentException("Not yet implemented");
    }

    private long loadLittle(byte[] data) {
        switch (data.length) {
            case 1: {
                return data[0] & 0xFF;
            }
            case 2: {
                return (data[0] & 0xFF) + (data[1] & 0xFF) * 256;
            }
            case 3: {
                return (data[0] & 0xFF) + (data[1] & 0xFF) * 256 + (data[2] & 0xFF) * 256 * 256;
            }
            case 4: {
                return (data[0] & 0xFF) + (data[1] & 0xFF) * 256 + (data[2] & 0xFF) * 256 * 256 + (data[3] & 0xFF) * 256 * 256 * 256;
            }
        }
        throw new IllegalArgumentException("Not yet implemented");
    }

    public int getAllocatedMemory() {
        return this.memory.getMemorySize();
    }

    public long load(long address, int length) {
        Preconditions.checkArgument(address >= 0L, "Error: Argument address can't be less than 0");
        Preconditions.checkArgument(length > 0, "Error: Argument length must be bigger than 0");
        if (this.endianness == Endianness.LITTLE_ENDIAN) {
            return this.loadLittle(this.memory.getData(address, length));
        }
        return this.loadBig(this.memory.getData(address, length));
    }

    public void printMemory() {
        this.memory.printMemory();
    }

    public void store(long address, long value, int length) {
        Preconditions.checkArgument(address >= 0L, "Error: Argument address can't be less than 0");
        Preconditions.checkArgument(length > 0, "Error: Argument length must be bigger than 0");
        this.memory.store(address, this.getData(value, length));
    }
}

