/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.interpreter;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.OperandType;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.ReilOperand;
import com.google.security.zynamics.reil.interpreter.Endianness;
import com.google.security.zynamics.reil.interpreter.ICpuPolicy;
import com.google.security.zynamics.reil.interpreter.IInterpreterPolicy;
import com.google.security.zynamics.reil.interpreter.InterpreterException;
import com.google.security.zynamics.reil.interpreter.ReilMemory;
import com.google.security.zynamics.reil.interpreter.ReilRegister;
import com.google.security.zynamics.reil.interpreter.ReilRegisterStatus;
import com.google.security.zynamics.zylib.general.Pair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ReilInterpreter {
    private static final String SUB_PC = "sub_PC";
    private final ICpuPolicy cpuPolicy;
    private final IInterpreterPolicy interpreterPolicy;
    private final HashMap<String, ReilRegister> registers = new HashMap();
    private final ReilMemory memory;

    public ReilInterpreter(Endianness endianness, ICpuPolicy cpuPolicy, IInterpreterPolicy interpreterPolicy) {
        Preconditions.checkNotNull(endianness, "Error: Argument endianness can't be null");
        this.cpuPolicy = Preconditions.checkNotNull(cpuPolicy, "Error: Argument cpuPolicy can't be null");
        this.interpreterPolicy = Preconditions.checkNotNull(interpreterPolicy, "Error: Argument interpreterPolicy can't be null");
        this.memory = new ReilMemory(endianness);
    }

    private static BigInteger getTruncateMask(OperandSize targetSize) {
        switch (targetSize) {
            case BYTE: {
                return BigInteger.valueOf(255L);
            }
            case DWORD: {
                return BigInteger.valueOf(0xFFFFFFFFL);
            }
            case QWORD: {
                return BigInteger.valueOf(-1L);
            }
            case OWORD: {
                return BigInteger.valueOf(0xFFFFFFFFFFFFFFL).shiftLeft(56).add(BigInteger.valueOf(0xFFFFFFFFFFFFFFL)).shiftLeft(16).add(BigInteger.valueOf(65535L));
            }
            case WORD: {
                return BigInteger.valueOf(65535L);
            }
        }
        throw new IllegalStateException("Error: Unknown target size for truncate mask");
    }

    private static void log(String msg, Object ... args) {
        System.out.printf(msg, args);
    }

    public static BigInteger nativeToReil(BigInteger address) {
        return address.multiply(BigInteger.valueOf(256L));
    }

    private void interpretAdd(ReilInstruction instruction) {
        Pair<Boolean, BigInteger> firstValue = this.loadLongValue(instruction.getFirstOperand());
        Pair<Boolean, BigInteger> secondValue = this.loadLongValue(instruction.getSecondOperand());
        if (firstValue.first().booleanValue() && secondValue.first().booleanValue()) {
            OperandSize targetSize = instruction.getThirdOperand().getSize();
            BigInteger result = firstValue.second().add(secondValue.second());
            String targetRegister = instruction.getThirdOperand().getValue();
            this.setRegister(targetRegister, result, targetSize, ReilRegisterStatus.DEFINED);
        } else assert (false);
    }

    private void interpretAnd(ReilInstruction instruction) {
        Pair<Boolean, BigInteger> firstValue = this.loadLongValue(instruction.getFirstOperand());
        Pair<Boolean, BigInteger> secondValue = this.loadLongValue(instruction.getSecondOperand());
        if (firstValue.first().booleanValue() && secondValue.first().booleanValue()) {
            BigInteger result = firstValue.second().and(secondValue.second());
            String targetRegister = instruction.getThirdOperand().getValue();
            OperandSize targetSize = instruction.getThirdOperand().getSize();
            this.setRegister(targetRegister, result, targetSize, ReilRegisterStatus.DEFINED);
        } else assert (false);
    }

    private void interpretBisz(ReilInstruction instruction) {
        Pair<Boolean, BigInteger> firstValue = this.loadLongValue(instruction.getFirstOperand());
        if (firstValue.first().booleanValue()) {
            BigInteger result = firstValue.second().equals(BigInteger.ZERO) ? BigInteger.ONE : BigInteger.ZERO;
            String targetRegister = instruction.getThirdOperand().getValue();
            OperandSize targetSize = instruction.getThirdOperand().getSize();
            this.setRegister(targetRegister, result, targetSize, ReilRegisterStatus.DEFINED);
        } else assert (false);
    }

    private void interpretBsh(ReilInstruction instruction) {
        Pair<Boolean, BigInteger> firstValue = this.loadLongValue(instruction.getFirstOperand());
        Pair<Boolean, BigInteger> secondValue = this.loadLongValue(instruction.getSecondOperand());
        if (firstValue.first().booleanValue() && secondValue.first().booleanValue()) {
            boolean isMsbSet = !secondValue.second().and(BigInteger.valueOf((long)Math.pow(2.0, instruction.getSecondOperand().getSize().getBitSize() - 1))).equals(BigInteger.ZERO);
            BigInteger result = BigInteger.ZERO;
            if (secondValue.second().compareTo(BigInteger.ZERO) < 0) {
                String string2 = String.valueOf(firstValue.second());
                System.out.println(new StringBuilder(1 + String.valueOf(string2).length()).append("F").append(string2).toString());
                string2 = String.valueOf(secondValue.second().negate());
                System.out.println(new StringBuilder(1 + String.valueOf(string2).length()).append("S").append(string2).toString());
                result = firstValue.second().shiftRight(secondValue.second().negate().intValue());
            } else {
                result = isMsbSet ? firstValue.second().shiftRight(BigInteger.ZERO.subtract(secondValue.second()).and(BigInteger.valueOf(255L)).intValue()) : firstValue.second().shiftLeft(secondValue.second().intValue());
            }
            String targetRegister = instruction.getThirdOperand().getValue();
            OperandSize targetSize = instruction.getThirdOperand().getSize();
            this.setRegister(targetRegister, result, targetSize, ReilRegisterStatus.DEFINED);
        } else assert (false);
    }

    private void interpretDiv(ReilInstruction instruction) {
        Pair<Boolean, BigInteger> firstValue = this.loadLongValue(instruction.getFirstOperand());
        Pair<Boolean, BigInteger> secondValue = this.loadLongValue(instruction.getSecondOperand());
        if (firstValue.first().booleanValue() && secondValue.first().booleanValue()) {
            BigInteger result = firstValue.second().divide(secondValue.second());
            String targetRegister = instruction.getThirdOperand().getValue();
            OperandSize targetSize = instruction.getThirdOperand().getSize();
            this.setRegister(targetRegister, result, targetSize, ReilRegisterStatus.DEFINED);
        } else assert (false);
    }

    private void interpretInstruction(ReilInstruction instruction, String programCounter) {
        Integer mnemonic = instruction.getMnemonicCode();
        switch (mnemonic) {
            case 0: {
                this.interpretAdd(instruction);
                break;
            }
            case 1: {
                this.interpretAnd(instruction);
                break;
            }
            case 2: {
                this.interpretBisz(instruction);
                break;
            }
            case 3: {
                this.interpretBsh(instruction);
                break;
            }
            case 6: {
                this.interpretDiv(instruction);
                break;
            }
            case 7: {
                this.interpretJcc(instruction, programCounter);
                break;
            }
            case 8: {
                this.interpretLdm(instruction);
                break;
            }
            case 9: {
                this.interpretMod(instruction);
                break;
            }
            case 10: {
                this.interpretMul(instruction);
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                this.interpretOr(instruction);
                break;
            }
            case 13: {
                this.interpretStm(instruction);
                break;
            }
            case 14: {
                this.interpretStr(instruction);
                break;
            }
            case 15: {
                this.interpretSub(instruction);
                break;
            }
            case 16: {
                this.interpretUndef(instruction);
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                this.interpretXor(instruction);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid Mnemonic in REIL interpreting loop");
            }
        }
    }

    private void interpretJcc(ReilInstruction instruction, String programCounter) {
        Pair<Boolean, BigInteger> firstValue = this.loadLongValue(instruction.getFirstOperand());
        if (!firstValue.second().equals(BigInteger.ZERO) && instruction.getThirdOperand().getType() == OperandType.SUB_ADDRESS) {
            String[] parts = instruction.getThirdOperand().getValue().split("\\.");
            assert (parts.length == 2);
            this.setRegister(programCounter, new BigInteger(parts[0]), OperandSize.DWORD, ReilRegisterStatus.DEFINED);
            this.setRegister(SUB_PC, new BigInteger(parts[1]), OperandSize.DWORD, ReilRegisterStatus.DEFINED);
        } else if (!firstValue.second().equals(BigInteger.ZERO)) {
            Pair<Boolean, BigInteger> secondValue = this.loadLongValue(instruction.getThirdOperand());
            this.setRegister(programCounter, secondValue.second(), OperandSize.DWORD, ReilRegisterStatus.DEFINED);
        }
    }

    private void interpretLdm(ReilInstruction instruction) {
        Pair<Boolean, BigInteger> firstValue = this.loadLongValue(instruction.getFirstOperand());
        if (firstValue.first().booleanValue()) {
            String target = instruction.getThirdOperand().getValue();
            int targetSize = instruction.getThirdOperand().getSize().getByteSize();
            BigInteger value = new BigInteger(String.valueOf(this.memory.load(firstValue.second().longValue(), targetSize)));
            this.setRegister(target, value, instruction.getThirdOperand().getSize(), ReilRegisterStatus.DEFINED);
        } else assert (false);
    }

    private void interpretMod(ReilInstruction instruction) {
        Pair<Boolean, BigInteger> firstValue = this.loadLongValue(instruction.getFirstOperand());
        Pair<Boolean, BigInteger> secondValue = this.loadLongValue(instruction.getSecondOperand());
        if (firstValue.first().booleanValue() && secondValue.first().booleanValue()) {
            BigInteger result = firstValue.second().mod(secondValue.second());
            String targetRegister = instruction.getThirdOperand().getValue();
            OperandSize targetSize = instruction.getThirdOperand().getSize();
            this.setRegister(targetRegister, result, targetSize, ReilRegisterStatus.DEFINED);
        } else assert (false);
    }

    private void interpretMul(ReilInstruction instruction) {
        Pair<Boolean, BigInteger> firstValue = this.loadLongValue(instruction.getFirstOperand());
        Pair<Boolean, BigInteger> secondValue = this.loadLongValue(instruction.getSecondOperand());
        if (firstValue.first().booleanValue() && secondValue.first().booleanValue()) {
            BigInteger result = firstValue.second().multiply(secondValue.second());
            String targetRegister = instruction.getThirdOperand().getValue();
            OperandSize targetSize = instruction.getThirdOperand().getSize();
            this.setRegister(targetRegister, result, targetSize, ReilRegisterStatus.DEFINED);
        } else assert (false);
    }

    private void interpretOr(ReilInstruction instruction) {
        Pair<Boolean, BigInteger> firstValue = this.loadLongValue(instruction.getFirstOperand());
        Pair<Boolean, BigInteger> secondValue = this.loadLongValue(instruction.getSecondOperand());
        if (firstValue.first().booleanValue() && secondValue.first().booleanValue()) {
            BigInteger result = firstValue.second().or(secondValue.second());
            String targetRegister = instruction.getThirdOperand().getValue();
            OperandSize targetSize = instruction.getThirdOperand().getSize();
            this.setRegister(targetRegister, result, targetSize, ReilRegisterStatus.DEFINED);
        } else assert (false);
    }

    private void interpretStm(ReilInstruction instruction) {
        Pair<Boolean, BigInteger> sourceValue = this.loadLongValue(instruction.getFirstOperand());
        Pair<Boolean, BigInteger> targetValue = this.loadLongValue(instruction.getThirdOperand());
        if (sourceValue.first().booleanValue() && targetValue.first().booleanValue()) {
            int targetSize = instruction.getFirstOperand().getSize().getByteSize();
            this.memory.store(targetValue.second().longValue(), sourceValue.second().longValue(), targetSize);
        } else {
            ReilInterpreter.log("%s", sourceValue.toString());
            ReilInterpreter.log("%s", targetValue.toString());
            assert (false);
        }
    }

    private void interpretStr(ReilInstruction instruction) {
        Pair<Boolean, BigInteger> firstValue = this.loadLongValue(instruction.getFirstOperand());
        if (firstValue.first().booleanValue()) {
            BigInteger result = firstValue.second();
            String targetRegister = instruction.getThirdOperand().getValue();
            OperandSize targetSize = instruction.getThirdOperand().getSize();
            this.setRegister(targetRegister, result, targetSize, ReilRegisterStatus.DEFINED);
        } else assert (false);
    }

    private void interpretSub(ReilInstruction instruction) {
        Pair<Boolean, BigInteger> firstValue = this.loadLongValue(instruction.getFirstOperand());
        Pair<Boolean, BigInteger> secondValue = this.loadLongValue(instruction.getSecondOperand());
        if (firstValue.first().booleanValue() && secondValue.first().booleanValue()) {
            OperandSize targetSize = instruction.getThirdOperand().getSize();
            BigInteger result = firstValue.second().subtract(secondValue.second()).and(ReilInterpreter.getTruncateMask(targetSize));
            String targetRegister = instruction.getThirdOperand().getValue();
            this.setRegister(targetRegister, result, targetSize, ReilRegisterStatus.DEFINED);
        } else assert (false);
    }

    private void interpretUndef(ReilInstruction instruction) {
        this.registers.remove(instruction.getThirdOperand().getValue());
    }

    private void interpretXor(ReilInstruction instruction) {
        Pair<Boolean, BigInteger> firstValue = this.loadLongValue(instruction.getFirstOperand());
        Pair<Boolean, BigInteger> secondValue = this.loadLongValue(instruction.getSecondOperand());
        if (firstValue.first().booleanValue() && secondValue.first().booleanValue()) {
            BigInteger result = firstValue.second().xor(secondValue.second());
            String targetRegister = instruction.getThirdOperand().getValue();
            OperandSize targetSize = instruction.getThirdOperand().getSize();
            this.setRegister(targetRegister, result, targetSize, ReilRegisterStatus.DEFINED);
        } else if (instruction.getFirstOperand().getValue().equals(instruction.getSecondOperand().getValue())) {
            String targetRegister = instruction.getThirdOperand().getValue();
            OperandSize targetSize = instruction.getThirdOperand().getSize();
            this.setRegister(targetRegister, BigInteger.ZERO, targetSize, ReilRegisterStatus.DEFINED);
        } else assert (false);
    }

    private Pair<Boolean, BigInteger> loadLongValue(ReilOperand operand) {
        OperandType type = operand.getType();
        String value = operand.getValue();
        if (type == OperandType.INTEGER_LITERAL) {
            return new Pair<Boolean, BigInteger>(true, new BigInteger(value));
        }
        if (type == OperandType.REGISTER) {
            value = value.charAt(0) == '-' ? operand.getValue().substring(1) : value;
            return !this.isDefined(value) ? new Pair<Boolean, BigInteger>(false, BigInteger.ZERO) : new Pair<Boolean, BigInteger>(true, this.getVariableValue(value));
        }
        return new Pair<Boolean, BigInteger>(false, BigInteger.ZERO);
    }

    private boolean searchNextPc(BigInteger pc, HashMap<BigInteger, List<ReilInstruction>> instructions, String programCounter) {
        for (int i2 = 0; i2 < 10; ++i2) {
            BigInteger current = pc.add(BigInteger.valueOf(i2));
            if (!instructions.containsKey(ReilInterpreter.nativeToReil(current))) continue;
            this.setRegister(programCounter, current, OperandSize.DWORD, ReilRegisterStatus.DEFINED);
            return true;
        }
        return false;
    }

    public ICpuPolicy getCpuPolicy() {
        return this.cpuPolicy;
    }

    public List<ReilRegister> getDefinedRegisters() {
        return new ArrayList<ReilRegister>(this.registers.values());
    }

    public ReilMemory getMemory() {
        return this.memory;
    }

    public long getMemorySize() {
        return this.memory.getAllocatedMemory();
    }

    public BigInteger getVariableValue(String register2) {
        Preconditions.checkNotNull(register2, "Error: register argument can not be null");
        Preconditions.checkArgument(this.registers.containsKey(register2), "Error: Register has no value");
        return this.registers.get(register2).getValue();
    }

    public void interpret(HashMap<BigInteger, List<ReilInstruction>> instructions, BigInteger entryPoint) throws InterpreterException {
        BigInteger pc;
        BigInteger pcNew;
        this.cpuPolicy.start(this);
        this.interpreterPolicy.start();
        String programCounter = this.cpuPolicy.getProgramCounter();
        Preconditions.checkNotNull(programCounter, "Error: CPU Policy returned an invalid program counter");
        this.setRegister(programCounter, entryPoint, this.cpuPolicy.getRegisterSize(programCounter), ReilRegisterStatus.DEFINED);
        do {
            pc = ReilInterpreter.nativeToReil(this.getVariableValue(programCounter));
            this.interpreterPolicy.nextInstruction(this);
            ReilInterpreter.log("Interpreting: %X%n", pc.longValue());
            if (!instructions.containsKey(pc)) {
                throw new InterpreterException(String.format("Error: Instruction at offset %X not found", pc));
            }
            List<ReilInstruction> instructionList = instructions.get(pc);
            if (instructionList == null || instructionList.size() == 0) {
                throw new InterpreterException(String.format("Error: Instruction at offset %X has invalid REIL code", pc));
            }
            this.setRegister(SUB_PC, BigInteger.ZERO, OperandSize.DWORD, ReilRegisterStatus.DEFINED);
            int subPc = this.getVariableValue(SUB_PC).intValue();
            while (subPc < instructionList.size()) {
                ReilInstruction inst = instructionList.get(subPc);
                String string2 = String.valueOf(inst.toString().replaceAll("%", ""));
                ReilInterpreter.log(string2.length() != 0 ? "Next instruction: ".concat(string2) : new String("Next instruction: "), new Object[0]);
                for (ReilRegister r2 : this.registers.values()) {
                    ReilInterpreter.log("%s: %X%n", r2.getRegister(), r2.getValue());
                }
                this.interpretInstruction(inst, programCounter);
                int newSubPc = this.getVariableValue(SUB_PC).intValue();
                subPc = subPc == newSubPc ? newSubPc + 1 : newSubPc;
                this.setRegister(SUB_PC, BigInteger.valueOf(subPc), OperandSize.DWORD, ReilRegisterStatus.DEFINED);
            }
            pcNew = this.getVariableValue(programCounter);
            pc = pc.equals(ReilInterpreter.nativeToReil(pcNew)) ? pcNew.add(BigInteger.ONE) : pcNew;
        } while (!pcNew.equals(BigInteger.valueOf(0xFFFFFFFFL)) && this.searchNextPc(pc, instructions, programCounter));
        this.interpreterPolicy.end();
    }

    public boolean isDefined(String register2) {
        System.out.println(this.registers.keySet());
        return this.registers.containsKey(register2);
    }

    public byte readMemoryByte(long address) {
        return (byte)this.memory.load(address, 1);
    }

    public long readMemoryDword(long address) {
        return this.memory.load(address, 4);
    }

    public long readMemoryWord(long address) {
        return this.memory.load(address, 2);
    }

    public void setMemory(long address, long value, int length) {
        this.memory.store(address, value, length);
    }

    public void setRegister(String register2, BigInteger value, OperandSize size, ReilRegisterStatus status) {
        BigInteger truncatedValue = value.and(ReilInterpreter.getTruncateMask(size));
        ReilRegister r2 = new ReilRegister(register2, size, truncatedValue);
        if (this.registers.containsKey(register2)) {
            this.registers.remove(register2);
        }
        if (status == ReilRegisterStatus.DEFINED) {
            this.registers.put(register2, r2);
        }
    }
}

