/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.interpreter;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.interpreter.ICpuPolicy;
import com.google.security.zynamics.reil.interpreter.IInterpreterPolicy;
import com.google.security.zynamics.reil.interpreter.ReilInterpreter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;

public class DumpPolicy
implements IInterpreterPolicy {
    private BufferedWriter writer = null;

    public DumpPolicy(String filename) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(new File(filename)));
    }

    private void printRegisters(ReilInterpreter interpreter, ICpuPolicy cpuPolicy, String[] registers, String[] flags) throws IOException {
        for (String register2 : registers) {
            BigInteger value = interpreter.isDefined(register2) ? interpreter.getVariableValue(register2) : BigInteger.ZERO;
            OperandSize registerSize = cpuPolicy.getRegisterSize(register2);
            int n2 = 2 * registerSize.getByteSize();
            String mask = new StringBuilder(14).append("%0").append(n2).append("X").toString();
            this.writer.write(String.format(new StringBuilder(5 + String.valueOf(mask).length()).append("%s: ").append(mask).append(" ").toString(), register2.toUpperCase(), value));
        }
        long value = 0L;
        int i2 = 0;
        for (String flag : flags) {
            int flagValue = interpreter.isDefined(flag) ? interpreter.getVariableValue(flag).intValue() : 0;
            value += (long)(flagValue << 31 - i2);
            ++i2;
        }
        this.writer.write(String.format("%s: %08X ", "FOO", value));
        this.writer.write("\n");
    }

    @Override
    public void end() {
        block2: {
            try {
                this.writer.close();
            }
            catch (Exception e2) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    public void nextInstruction(ReilInterpreter interpreter) {
        block2: {
            ICpuPolicy cpuPolicy = interpreter.getCpuPolicy();
            String[] registers = cpuPolicy.getRegisters();
            String[] flags = cpuPolicy.getFlags();
            try {
                this.printRegisters(interpreter, cpuPolicy, registers, flags);
            }
            catch (IOException e2) {
                System.out.println(e2);
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    public void start() {
    }
}

