/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.interpreter;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.interpreter.ICpuPolicy;
import com.google.security.zynamics.reil.interpreter.ReilInterpreter;

public class CpuPolicyX86
implements ICpuPolicy {
    private static String[] registers = new String[]{"eax", "ebx", "ecx", "edx", "esi", "edi", "eip"};
    private static String[] flags = new String[]{"CF", "SF", "ZF", "OF"};

    @Override
    public String[] getFlags() {
        return (String[])flags.clone();
    }

    @Override
    public String getProgramCounter() {
        return "eip";
    }

    @Override
    public String[] getRegisters() {
        return (String[])registers.clone();
    }

    @Override
    public OperandSize getRegisterSize(String value) {
        if (value.equals("al") || value.equals("ah") || value.equals("bl") || value.equals("bh") || value.equals("cl") || value.equals("ch") || value.equals("dl") || value.equals("dh")) {
            return OperandSize.BYTE;
        }
        if (value.equals("ax") || value.equals("bx") || value.equals("cx") || value.equals("dx") || value.equals("si") || value.equals("di") || value.equals("sp") || value.equals("bp") || value.equals("ip")) {
            return OperandSize.WORD;
        }
        if (value.equals("eax") || value.equals("ebx") || value.equals("ecx") || value.equals("edx") || value.equals("esi") || value.equals("edi") || value.equals("esp") || value.equals("ebp") || value.equals("eip")) {
            return OperandSize.DWORD;
        }
        assert (false);
        return null;
    }

    @Override
    public void start(ReilInterpreter interpreter) {
    }
}

