/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono2.registertracking;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.OperandType;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.ReilOperand;
import com.google.security.zynamics.reil.algorithms.mono2.common.PerInstructionTransformationProvider;
import com.google.security.zynamics.reil.algorithms.mono2.common.enums.AnalysisDirection;
import com.google.security.zynamics.reil.algorithms.mono2.registertracking.RegisterSetLatticeElement;
import com.google.security.zynamics.reil.algorithms.mono2.registertracking.RegisterTrackingOptions;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.TreeSet;

public class RegisterTrackingTransformationProvider
extends PerInstructionTransformationProvider<RegisterSetLatticeElement> {
    private final RegisterTrackingOptions m_trackingOptions;

    public RegisterTrackingTransformationProvider(RegisterTrackingOptions options) {
        this.m_trackingOptions = options;
    }

    private String getMask(OperandSize operandSize) {
        switch (operandSize) {
            case BYTE: {
                return String.valueOf(255L);
            }
            case DWORD: {
                return String.valueOf(0xFFFFFFFFL);
            }
            case QWORD: {
                return String.valueOf(-1L);
            }
            case WORD: {
                return String.valueOf(65535L);
            }
        }
        throw new IllegalStateException("Error: Unknown target size for truncate mask");
    }

    private Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformNormalInstruction(ReilInstruction ins, RegisterSetLatticeElement state) {
        if (this.m_trackingOptions.getAnalysisDirection() == AnalysisDirection.UP) {
            return this.transformNormalInstructionBackward(ins, state);
        }
        return this.transformNormalInstructionForward(ins, state);
    }

    private Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformNormalInstructionBackward(ReilInstruction ins, RegisterSetLatticeElement state) {
        ReilOperand in1 = ins.getFirstOperand();
        ReilOperand in2 = ins.getSecondOperand();
        ReilOperand out = ins.getThirdOperand();
        TreeSet<String> inputRegisters = new TreeSet<String>();
        if (in1.getType() == OperandType.REGISTER) {
            inputRegisters.add(in1.getValue());
        }
        if (in2.getType() == OperandType.REGISTER) {
            inputRegisters.add(in2.getValue());
        }
        RegisterSetLatticeElement outputstate = state.copy();
        if (state.isTainted(out.getValue())) {
            if (inputRegisters.isEmpty()) {
                outputstate.untaint(out.getValue());
            } else {
                outputstate.untaint(out.getValue());
                outputstate.addReadReg(out.getValue());
                for (String register2 : inputRegisters) {
                    outputstate.taint(register2);
                }
            }
        }
        return new Pair<RegisterSetLatticeElement, Object>(outputstate, null);
    }

    private Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformNormalInstructionForward(ReilInstruction ins, RegisterSetLatticeElement state) {
        ReilOperand in1 = ins.getFirstOperand();
        ReilOperand in2 = ins.getSecondOperand();
        ReilOperand out = ins.getThirdOperand();
        TreeSet<String> inputRegisters = new TreeSet<String>();
        if (in1.getType() == OperandType.REGISTER) {
            inputRegisters.add(in1.getValue());
        }
        if (in2.getType() == OperandType.REGISTER) {
            inputRegisters.add(in2.getValue());
        }
        RegisterSetLatticeElement outputstate = state.copy();
        if (!state.isTainted(inputRegisters)) {
            outputstate.untaint(out.getValue());
        } else {
            for (String register2 : inputRegisters) {
                if (!state.isTainted(register2)) continue;
                outputstate.addReadReg(register2);
            }
            outputstate.taint(out.getValue());
        }
        return new Pair<RegisterSetLatticeElement, Object>(outputstate, null);
    }

    @Override
    protected Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformAdd(ReilInstruction ins, RegisterSetLatticeElement state) {
        return this.transformNormalInstruction(ins, state);
    }

    @Override
    protected Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformAnd(ReilInstruction ins, RegisterSetLatticeElement state) {
        if (ins.getFirstOperand().getType() == OperandType.INTEGER_LITERAL && ins.getFirstOperand().getValue().equalsIgnoreCase("0")) {
            RegisterSetLatticeElement newState = state.copy();
            newState.untaint(ins.getThirdOperand().getValue());
            return new Pair<RegisterSetLatticeElement, Object>(newState, null);
        }
        if (ins.getSecondOperand().getType() == OperandType.INTEGER_LITERAL && ins.getSecondOperand().getValue().equalsIgnoreCase("0")) {
            RegisterSetLatticeElement newState = state.copy();
            newState.untaint(ins.getThirdOperand().getValue());
            return new Pair<RegisterSetLatticeElement, Object>(newState, null);
        }
        return this.transformNormalInstruction(ins, state);
    }

    @Override
    protected Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformBisz(ReilInstruction ins, RegisterSetLatticeElement state) {
        return this.transformNormalInstruction(ins, state);
    }

    @Override
    protected Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformBsh(ReilInstruction ins, RegisterSetLatticeElement state) {
        return this.transformNormalInstruction(ins, state);
    }

    @Override
    protected Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformDiv(ReilInstruction ins, RegisterSetLatticeElement state) {
        return this.transformNormalInstruction(ins, state);
    }

    @Override
    protected Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformJcc(ReilInstruction ins, RegisterSetLatticeElement state) {
        RegisterSetLatticeElement newstate = state.copy();
        if (ReilHelpers.isFunctionCall(ins)) {
            if (this.m_trackingOptions.clearsAllRegisters()) {
                newstate.untaintAll(state.getTaintedRegisters());
            } else {
                newstate.untaintAll(this.m_trackingOptions.getClearedRegisters());
            }
        }
        return new Pair<RegisterSetLatticeElement, RegisterSetLatticeElement>(newstate, newstate);
    }

    @Override
    protected Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformLdm(ReilInstruction ins, RegisterSetLatticeElement state) {
        RegisterSetLatticeElement newstate = state.copy();
        newstate.untaint(ins.getThirdOperand().getValue());
        return new Pair<RegisterSetLatticeElement, Object>(newstate, null);
    }

    @Override
    protected Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformMod(ReilInstruction ins, RegisterSetLatticeElement state) {
        return this.transformNormalInstruction(ins, state);
    }

    @Override
    protected Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformMul(ReilInstruction ins, RegisterSetLatticeElement state) {
        if (ins.getFirstOperand().getType() == OperandType.INTEGER_LITERAL && ins.getFirstOperand().getValue().equalsIgnoreCase("0")) {
            RegisterSetLatticeElement newState = state.copy();
            newState.untaint(ins.getThirdOperand().getValue());
            return new Pair<RegisterSetLatticeElement, Object>(newState, null);
        }
        if (ins.getSecondOperand().getType() == OperandType.INTEGER_LITERAL && ins.getSecondOperand().getValue().equalsIgnoreCase("0")) {
            RegisterSetLatticeElement newState = state.copy();
            newState.untaint(ins.getThirdOperand().getValue());
            return new Pair<RegisterSetLatticeElement, Object>(newState, null);
        }
        return this.transformNormalInstruction(ins, state);
    }

    @Override
    protected Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformNop(ReilInstruction ins, RegisterSetLatticeElement state) {
        return this.transformNormalInstruction(ins, state);
    }

    @Override
    protected Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformOr(ReilInstruction ins, RegisterSetLatticeElement state) {
        OperandType operandOneType = ins.getFirstOperand().getType();
        OperandType operandTwoType = ins.getSecondOperand().getType();
        OperandSize operandOneSize = ins.getFirstOperand().getSize();
        OperandSize operandTwoSize = ins.getSecondOperand().getSize();
        OperandSize operandThreeSize = ins.getThirdOperand().getSize();
        String operandOneValue = ins.getFirstOperand().getValue();
        String operandTwoValue = ins.getSecondOperand().getValue();
        String mask = this.getMask(operandThreeSize);
        if (operandOneType == OperandType.INTEGER_LITERAL && mask.equalsIgnoreCase(operandOneValue) && operandThreeSize.equals((Object)operandTwoSize) && operandThreeSize.equals((Object)operandOneSize)) {
            RegisterSetLatticeElement newState = state.copy();
            newState.untaint(ins.getThirdOperand().getValue());
            return new Pair<RegisterSetLatticeElement, Object>(newState, null);
        }
        if (operandTwoType == OperandType.INTEGER_LITERAL && mask.equalsIgnoreCase(operandTwoValue) && operandThreeSize.equals((Object)operandTwoSize) && operandThreeSize.equals((Object)operandOneSize)) {
            RegisterSetLatticeElement newState = state.copy();
            newState.untaint(ins.getThirdOperand().getValue());
            return new Pair<RegisterSetLatticeElement, Object>(newState, null);
        }
        return this.transformNormalInstruction(ins, state);
    }

    @Override
    protected Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformStm(ReilInstruction ins, RegisterSetLatticeElement state) {
        ReilOperand op1 = ins.getFirstOperand();
        if (op1.getType().equals((Object)OperandType.REGISTER) && state.isTainted(op1.getValue())) {
            RegisterSetLatticeElement newState = state.copy();
            newState.addReadReg(op1.getValue());
            return new Pair<RegisterSetLatticeElement, Object>(newState, null);
        }
        return new Pair<RegisterSetLatticeElement, Object>(state, null);
    }

    @Override
    protected Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformStr(ReilInstruction ins, RegisterSetLatticeElement state) {
        return this.transformNormalInstruction(ins, state);
    }

    @Override
    protected Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformSub(ReilInstruction ins, RegisterSetLatticeElement state) {
        if (ins.getFirstOperand().getValue().equalsIgnoreCase(ins.getSecondOperand().getValue())) {
            RegisterSetLatticeElement newState = state.copy();
            newState.untaint(ins.getThirdOperand().getValue());
            return new Pair<RegisterSetLatticeElement, Object>(newState, null);
        }
        return this.transformNormalInstruction(ins, state);
    }

    @Override
    protected Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformUndef(ReilInstruction ins, RegisterSetLatticeElement state) {
        RegisterSetLatticeElement newstate = state.copy();
        newstate.untaint(ins.getThirdOperand().getValue());
        return new Pair<RegisterSetLatticeElement, Object>(newstate, null);
    }

    @Override
    protected Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformUnknown(ReilInstruction ins, RegisterSetLatticeElement state) {
        return new Pair<RegisterSetLatticeElement, Object>(state, null);
    }

    @Override
    protected Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformUnknownOpcode(ReilInstruction ins, RegisterSetLatticeElement state) {
        throw new IllegalArgumentException("Error: Unkown opcode when trying to calculate a transform");
    }

    @Override
    protected Pair<RegisterSetLatticeElement, RegisterSetLatticeElement> transformXor(ReilInstruction ins, RegisterSetLatticeElement state) {
        if (ins.getFirstOperand().getValue().equalsIgnoreCase(ins.getSecondOperand().getValue())) {
            RegisterSetLatticeElement newState = state.copy();
            newState.untaint(ins.getThirdOperand().getValue());
            return new Pair<RegisterSetLatticeElement, Object>(newState, null);
        }
        return this.transformNormalInstruction(ins, state);
    }
}

