/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono2.registertracking;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.algorithms.mono2.common.enums.AnalysisDirection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class RegisterTrackingOptions {
    private final boolean m_clearAll;
    private final Set<String> m_clearedRegisters;
    private final boolean m_trackIncoming;
    private final AnalysisDirection m_analysisDirection;

    public RegisterTrackingOptions(boolean clearAll, Set<String> clearedRegisters, boolean trackIncoming, AnalysisDirection analysisDirection) {
        this.m_clearAll = clearAll;
        this.m_clearedRegisters = new HashSet<String>((Collection)Preconditions.checkNotNull(clearedRegisters, "Error: clearedRegisters argument can not be null"));
        this.m_trackIncoming = trackIncoming;
        this.m_analysisDirection = Preconditions.checkNotNull(analysisDirection, "Error: Analysis direction argument can not be null");
    }

    public boolean clearsAllRegisters() {
        return this.m_clearAll;
    }

    public AnalysisDirection getAnalysisDirection() {
        return this.m_analysisDirection;
    }

    public Set<String> getClearedRegisters() {
        return new HashSet<String>(this.m_clearedRegisters);
    }

    public boolean trackIncoming() {
        return this.m_trackIncoming;
    }
}

