/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers;

import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.ValueTrackerElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.BitwiseXor;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IElementGenerator;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IValueElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.BaseTransformer;

public final class XorTransformer
extends BaseTransformer {
    private static IElementGenerator XOR_GENERATOR = new XorGenerator();

    public static ValueTrackerElement transform(ReilInstruction instruction, ValueTrackerElement incomingState) {
        return XorTransformer.transform(instruction, incomingState, XOR_GENERATOR);
    }

    private static class XorGenerator
    implements IElementGenerator {
        private XorGenerator() {
        }

        @Override
        public IValueElement generate(IValueElement lhs, IValueElement rhs) {
            if (lhs.equals(rhs)) {
                return lhs.clone();
            }
            return new BitwiseXor(lhs, rhs).getSimplified();
        }
    }
}

