/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers;

import com.google.security.zynamics.reil.OperandType;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.ReilOperand;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.ValueTrackerElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IValueElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.MemoryCell;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Undefined;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.BaseTransformer;

public final class StmTransformer
extends BaseTransformer {
    private static IValueElement getValue(ReilOperand firstOperand, IValueElement previousState2) {
        if (previousState2 instanceof Undefined) {
            return new Undefined();
        }
        return StmTransformer.getAtomicType(firstOperand);
    }

    public static ValueTrackerElement transform(ReilInstruction instruction, ValueTrackerElement state) {
        ReilOperand inputOperand = instruction.getFirstOperand();
        ReilOperand addressOperand = instruction.getThirdOperand();
        OperandType inputOperandType = inputOperand.getType();
        if (inputOperandType == OperandType.INTEGER_LITERAL) {
            IValueElement previousAddressState = state.getState(addressOperand.getValue());
            IValueElement outputValue = StmTransformer.getValue(inputOperand, previousAddressState);
            if (previousAddressState == null || previousAddressState instanceof Undefined) {
                IValueElement newThirdState = StmTransformer.getAtomicType(addressOperand);
                return state.update(instruction, new MemoryCell(newThirdState), outputValue);
            }
            IValueElement previousState2b = state.getState(new MemoryCell(previousAddressState));
            if (previousState2b == null || previousState2b instanceof Undefined) {
                return state.update(instruction, new MemoryCell(previousAddressState), outputValue);
            }
            return state.update(instruction, new MemoryCell(previousState2b), outputValue);
        }
        if (inputOperandType == OperandType.REGISTER) {
            IValueElement newThirdState = StmTransformer.getAtomicType(addressOperand);
            IValueElement previousStateInput = state.getState(inputOperand.getValue());
            IValueElement previousState2 = StmTransformer.getOperandValue(addressOperand, state);
            if (previousStateInput == null && previousState2 == null) {
                return state.update(instruction, new MemoryCell(newThirdState), StmTransformer.getAtomicType(inputOperand));
            }
            if (previousStateInput == null && previousState2 != null) {
                IValueElement previousState2b = state.getState(new MemoryCell(previousState2));
                if (previousState2b == null) {
                    return state.update(instruction, new MemoryCell(previousState2), StmTransformer.getAtomicType(inputOperand));
                }
                return state.update(instruction, new MemoryCell(previousState2b), StmTransformer.getAtomicType(inputOperand));
            }
            if (previousStateInput != null && previousState2 == null) {
                return state.update(instruction, new MemoryCell(newThirdState), previousStateInput);
            }
            if (previousState2 instanceof Undefined) {
                return state.update(instruction, new MemoryCell(newThirdState), new Undefined());
            }
            IValueElement previousState2b = state.getState(new MemoryCell(previousState2));
            if (previousState2b == null || previousState2b instanceof Undefined) {
                return state.update(instruction, new MemoryCell(previousState2), previousStateInput);
            }
            return state.update(instruction, new MemoryCell(previousState2b), previousStateInput);
        }
        throw new IllegalStateException("Not yet implemented");
    }
}

