/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers;

import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.algorithms.mono.WalkInformation;
import com.google.security.zynamics.reil.algorithms.mono.interfaces.IInfluencingState;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.ValueTrackerElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IAloc;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IValueElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Literal;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Range;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Undefined;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StateCombiner {
    private static IValueElement combine(IValueElement lhs, IValueElement rhs) {
        if (lhs.equals(rhs)) {
            return lhs.clone();
        }
        if (lhs instanceof Literal && rhs instanceof Literal) {
            Literal llhs = (Literal)lhs;
            Literal lrhs = (Literal)rhs;
            if (llhs.getValue().compareTo(lrhs.getValue()) == -1) {
                return new Range(llhs, lrhs);
            }
            return new Range(lrhs, llhs);
        }
        if (lhs instanceof Undefined || rhs instanceof Undefined) {
            return new Undefined();
        }
        return new Undefined();
    }

    private static ValueTrackerElement combine(ValueTrackerElement state1, ValueTrackerElement state2) {
        IAloc aloc;
        Map<IAloc, IValueElement> values1 = state1.getStates();
        Map<IAloc, IValueElement> values2 = state2.getStates();
        HashMap<IAloc, IValueElement> combinedState = new HashMap<IAloc, IValueElement>();
        Set<ReilInstruction> combinedInfluences = state1.getInfluences();
        combinedInfluences.addAll(state2.getInfluences());
        HashMap<String, Set<IAddress>> combinedWritten = new HashMap<String, Set<IAddress>>();
        combinedWritten.putAll(state1.getLastWritten());
        for (Map.Entry<String, Set<IAddress>> entry : state2.getLastWritten().entrySet()) {
            if (combinedWritten.containsKey(entry.getKey())) {
                ((Set)combinedWritten.get(entry.getKey())).addAll((Collection)entry.getValue());
                continue;
            }
            combinedWritten.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : values1.entrySet()) {
            aloc = (IAloc)entry.getKey();
            if (values2.containsKey(aloc)) {
                IValueElement lhs = (IValueElement)entry.getValue();
                IValueElement rhs = values2.get(aloc);
                combinedState.put(aloc, StateCombiner.combine(lhs, rhs));
                continue;
            }
            combinedState.put(aloc, new Undefined());
        }
        for (Map.Entry<Object, Object> entry : values2.entrySet()) {
            aloc = (IAloc)entry.getKey();
            if (values1.containsKey(aloc)) continue;
            combinedState.put(aloc, new Undefined());
        }
        if (combinedState.size() < state1.getStates().size() || combinedState.size() < state2.getStates().size()) {
            throw new IllegalStateException();
        }
        return new ValueTrackerElement(combinedInfluences, combinedState, combinedWritten);
    }

    public static ValueTrackerElement combine(List<IInfluencingState<ValueTrackerElement, WalkInformation>> states) {
        if (states.size() == 2) {
            ValueTrackerElement state2;
            ValueTrackerElement state1 = states.get(0).getElement();
            if (state1.equals(state2 = states.get(1).getElement())) {
                return state1.clone();
            }
            ValueTrackerElement result = StateCombiner.combine(state1, state2);
            if (result.getStates().size() < state1.getStates().size()) {
                System.out.println(state1);
                System.out.println(state2);
                System.out.println(result);
                throw new IllegalStateException();
            }
            if (result.getStates().size() < state2.getStates().size()) {
                System.out.println(state1);
                System.out.println(state2);
                System.out.println(result);
                throw new IllegalStateException();
            }
            return result;
        }
        throw new IllegalStateException("Not yet implemented");
    }
}

