/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers;

import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.ReilOperand;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.ValueTrackerElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Dereference;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IValueElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.MemoryCell;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Register;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Undefined;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.BaseTransformer;

public final class LdmTransformer
extends BaseTransformer {
    public static ValueTrackerElement transform(ReilInstruction instruction, ValueTrackerElement incomingState) {
        ReilOperand memoryAddressOperand = instruction.getFirstOperand();
        ReilOperand outputOperand = instruction.getThirdOperand();
        Register outputRegister = new Register(outputOperand.getValue());
        IValueElement memoryAddress = LdmTransformer.getOperandValue(memoryAddressOperand, incomingState);
        if (memoryAddress == null || memoryAddress instanceof Undefined) {
            IValueElement memoryAddressValue = LdmTransformer.getAtomicType(memoryAddressOperand);
            Dereference dereference = new Dereference(memoryAddressValue);
            return incomingState.update(instruction, outputRegister, dereference);
        }
        IValueElement previousState2 = incomingState.getState(new MemoryCell(memoryAddress));
        if (previousState2 == null) {
            return incomingState.update(instruction, outputRegister, new Dereference(memoryAddress));
        }
        return incomingState.update(instruction, outputRegister, previousState2);
    }
}

