/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers;

import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.ReilOperand;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.ValueTrackerElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IValueElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Literal;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.NullCheck;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Register;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Undefined;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.BaseTransformer;
import java.math.BigInteger;

public final class BiszTransformer
extends BaseTransformer {
    private static IValueElement getOutputValue(ReilOperand inputOperand, IValueElement previousState) {
        if (previousState == null) {
            return new NullCheck(BiszTransformer.getAtomicType(inputOperand));
        }
        if (previousState instanceof Undefined) {
            return new Undefined();
        }
        if (previousState instanceof Literal) {
            BigInteger inputValue = previousState.evaluate();
            return new NullCheck(new Literal(inputValue)).getSimplified();
        }
        return new NullCheck(previousState).getSimplified();
    }

    public static ValueTrackerElement transform(ReilInstruction instruction, ValueTrackerElement incomingState) {
        ReilOperand inputOperand = instruction.getFirstOperand();
        ReilOperand outputOperand = instruction.getThirdOperand();
        Register outputRegister = new Register(outputOperand.getValue());
        IValueElement inputValue = BiszTransformer.getOperandValue(inputOperand, incomingState);
        IValueElement outputValue = BiszTransformer.getOutputValue(inputOperand, inputValue);
        return incomingState.update(instruction, outputRegister, outputValue);
    }
}

