/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements;

import com.google.common.collect.Sets;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IValueElement;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Convert;
import java.math.BigInteger;
import java.util.Set;

public class Symbol
implements IValueElement {
    private final String m_value;
    private final IAddress m_address;

    public Symbol(IAddress address, String value) {
        if (Convert.isDecString(value)) {
            throw new IllegalStateException();
        }
        this.m_address = address;
        this.m_value = value;
    }

    @Override
    public Symbol clone() {
        return new Symbol(this.m_address, this.m_value);
    }

    @Override
    public boolean equals(Object rhs) {
        return rhs instanceof Symbol && ((Symbol)rhs).m_value.equals(this.m_value) && ((Symbol)rhs).m_address.equals(this.m_address);
    }

    @Override
    public BigInteger evaluate() {
        throw new IllegalStateException("Not yet implemented");
    }

    @Override
    public IValueElement getSimplified() {
        return this;
    }

    @Override
    public Set<String> getVariables() {
        return Sets.newHashSet(this.m_value);
    }

    @Override
    public int hashCode() {
        return this.m_address.hashCode() * this.m_value.hashCode();
    }

    public String toString() {
        String string2 = this.m_value;
        String string3 = String.valueOf(this.m_address.toHexString());
        return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("/").append(string3).toString();
    }
}

