/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Addition;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IValueElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Literal;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Undefined;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class Subtraction
implements IValueElement {
    private final IValueElement m_lhs;
    private final IValueElement m_rhs;

    public Subtraction(IValueElement lhs, IValueElement rhs) {
        Preconditions.checkArgument(!(lhs instanceof Undefined), "Error: LHS side of an Addition can not be undefined");
        Preconditions.checkArgument(!(rhs instanceof Undefined), "Error: RHS side of an Addition can not be undefined");
        this.m_lhs = lhs;
        this.m_rhs = rhs;
    }

    @Override
    public Subtraction clone() {
        return new Subtraction(this.m_lhs.clone(), this.m_rhs.clone());
    }

    @Override
    public boolean equals(Object rhs) {
        return rhs instanceof Subtraction && ((Subtraction)rhs).m_lhs.equals(this.m_lhs) && ((Subtraction)rhs).m_rhs.equals(this.m_rhs);
    }

    @Override
    public BigInteger evaluate() {
        return this.m_lhs.evaluate().subtract(this.m_rhs.evaluate());
    }

    public IValueElement getLhs() {
        return this.m_lhs;
    }

    public IValueElement getRhs() {
        return this.m_rhs;
    }

    @Override
    public IValueElement getSimplified() {
        IValueElement simplifiedLhs = this.m_lhs.getSimplified();
        IValueElement simplifiedRhs = this.m_rhs.getSimplified();
        if (simplifiedRhs instanceof Literal) {
            if (simplifiedLhs instanceof Literal) {
                return new Literal(((Literal)simplifiedLhs).getValue().subtract(((Literal)simplifiedRhs).getValue()));
            }
            if (simplifiedLhs instanceof Addition && ((Addition)simplifiedLhs).getRhs() instanceof Literal) {
                return new Addition(((Addition)simplifiedLhs).getLhs(), new Literal(((Literal)((Addition)simplifiedLhs).getRhs()).getValue().subtract(((Literal)simplifiedRhs).getValue())));
            }
            if (simplifiedLhs instanceof Subtraction && ((Subtraction)simplifiedLhs).getRhs() instanceof Literal) {
                return new Subtraction(((Subtraction)simplifiedLhs).getLhs(), new Literal(((Literal)((Subtraction)simplifiedLhs).getRhs()).getValue().add(((Literal)simplifiedRhs).getValue())));
            }
        }
        return new Subtraction(simplifiedLhs, simplifiedRhs);
    }

    @Override
    public Set<String> getVariables() {
        HashSet<String> variables = new HashSet<String>();
        variables.addAll(this.m_lhs.getVariables());
        variables.addAll(this.m_rhs.getVariables());
        return variables;
    }

    @Override
    public int hashCode() {
        return this.m_lhs.hashCode() * this.m_rhs.hashCode() * this.m_rhs.hashCode();
    }

    public String toString() {
        String string2 = String.valueOf(this.m_lhs);
        String string3 = String.valueOf(this.m_rhs);
        return new StringBuilder(5 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("(").append(string2).append(" - ").append(string3).append(")").toString();
    }
}

