/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IValueElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Literal;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Undefined;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class BitwiseShift
implements IValueElement {
    private final IValueElement m_lhs;
    private final IValueElement m_rhs;

    public BitwiseShift(IValueElement lhs, IValueElement rhs) {
        Preconditions.checkNotNull(lhs, "Error: lhs argument can not be null");
        Preconditions.checkNotNull(rhs, "Error: rhs argument can not be null");
        Preconditions.checkArgument(!(lhs instanceof Undefined), "Error: LHS side of an Addition can not be undefined");
        Preconditions.checkArgument(!(rhs instanceof Undefined), "Error: RHS side of an Addition can not be undefined");
        this.m_lhs = lhs;
        this.m_rhs = rhs;
    }

    @Override
    public BitwiseShift clone() {
        return new BitwiseShift(this.m_lhs.clone(), this.m_rhs.clone());
    }

    @Override
    public boolean equals(Object rhs) {
        return rhs instanceof BitwiseShift && ((BitwiseShift)rhs).m_lhs.equals(this.m_lhs) && ((BitwiseShift)rhs).m_rhs.equals(this.m_rhs);
    }

    @Override
    public BigInteger evaluate() {
        throw new IllegalStateException("Not yet implemented");
    }

    public IValueElement getLhs() {
        return this.m_lhs;
    }

    public IValueElement getRhs() {
        return this.m_rhs;
    }

    @Override
    public IValueElement getSimplified() {
        IValueElement simplifiedLhs = this.m_lhs.getSimplified();
        IValueElement simplifiedRhs = this.m_rhs.getSimplified();
        if (simplifiedLhs instanceof Literal && simplifiedRhs instanceof Literal) {
            Literal lhs = (Literal)simplifiedLhs;
            Literal rhs = (Literal)simplifiedRhs;
            BigInteger lhsValue = lhs.getValue();
            BigInteger rhsValue = rhs.getValue();
            if (lhsValue.compareTo(BigInteger.ZERO) == -1) {
                BigInteger result = lhsValue.shiftLeft(rhsValue.intValue());
                return new Literal(result);
            }
            BigInteger result = lhsValue.shiftRight(rhsValue.intValue());
            return new Literal(result);
        }
        return this.clone();
    }

    @Override
    public Set<String> getVariables() {
        HashSet<String> variables = new HashSet<String>();
        variables.addAll(this.m_lhs.getVariables());
        variables.addAll(this.m_rhs.getVariables());
        return variables;
    }

    @Override
    public int hashCode() {
        return 777 * this.m_lhs.hashCode() * this.m_rhs.hashCode();
    }

    public String toString() {
        if (this.m_rhs instanceof Literal) {
            BigInteger value = ((Literal)this.m_rhs).getValue();
            if (value.compareTo(BigInteger.ZERO) < 0) {
                String string2 = String.valueOf(this.m_lhs);
                String string3 = String.valueOf(value.abs());
                return new StringBuilder(6 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("(").append(string2).append(" >> ").append(string3).append(")").toString();
            }
            String string4 = String.valueOf(this.m_lhs);
            String string5 = String.valueOf(this.m_rhs);
            return new StringBuilder(6 + String.valueOf(string4).length() + String.valueOf(string5).length()).append("(").append(string4).append(" << ").append(string5).append(")").toString();
        }
        String string6 = String.valueOf(this.m_lhs);
        String string7 = String.valueOf(this.m_rhs);
        return new StringBuilder(9 + String.valueOf(string6).length() + String.valueOf(string7).length()).append("(").append(string6).append(" SHIFT ").append(string7).append(")").toString();
    }
}

