/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.IValueElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Literal;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.elements.Undefined;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class BitwiseAnd
implements IValueElement {
    private final IValueElement m_lhs;
    private final IValueElement m_rhs;

    public BitwiseAnd(IValueElement lhs, IValueElement rhs) {
        Preconditions.checkArgument(!(lhs instanceof Undefined), "Error: LHS side of an Addition can not be undefined");
        Preconditions.checkArgument(!(rhs instanceof Undefined), "Error: RHS side of an Addition can not be undefined");
        this.m_lhs = lhs;
        this.m_rhs = rhs;
    }

    @Override
    public BitwiseAnd clone() {
        return new BitwiseAnd(this.m_lhs.clone(), this.m_rhs.clone());
    }

    @Override
    public boolean equals(Object rhs) {
        return rhs instanceof BitwiseAnd && ((BitwiseAnd)rhs).m_lhs.equals(this.m_lhs) && ((BitwiseAnd)rhs).m_rhs.equals(this.m_rhs);
    }

    @Override
    public BigInteger evaluate() {
        return this.m_lhs.evaluate().and(this.m_rhs.evaluate());
    }

    public IValueElement getLhs() {
        return this.m_lhs;
    }

    public IValueElement getRhs() {
        return this.m_rhs;
    }

    @Override
    public IValueElement getSimplified() {
        IValueElement simplifiedLhs = this.m_lhs.getSimplified();
        IValueElement simplifiedRhs = this.m_rhs.getSimplified();
        if (simplifiedLhs instanceof BitwiseAnd) {
            if (((BitwiseAnd)simplifiedLhs).getRhs().equals(simplifiedRhs)) {
                return simplifiedLhs;
            }
            if (((BitwiseAnd)simplifiedLhs).getLhs().equals(simplifiedRhs)) {
                return simplifiedLhs;
            }
            return new BitwiseAnd(simplifiedLhs, simplifiedRhs);
        }
        if (simplifiedRhs instanceof BitwiseAnd) {
            if (((BitwiseAnd)simplifiedRhs).getRhs().equals(simplifiedLhs)) {
                return simplifiedRhs;
            }
            if (((BitwiseAnd)simplifiedRhs).getLhs().equals(simplifiedLhs)) {
                return simplifiedRhs;
            }
            return new BitwiseAnd(simplifiedLhs, simplifiedRhs);
        }
        if (simplifiedRhs instanceof Literal && simplifiedLhs instanceof Literal) {
            return new Literal(((Literal)simplifiedLhs).getValue().and(((Literal)simplifiedRhs).getValue()));
        }
        return new BitwiseAnd(simplifiedLhs, simplifiedRhs);
    }

    @Override
    public Set<String> getVariables() {
        HashSet<String> set = Sets.newHashSet(this.m_lhs.getVariables());
        set.addAll(this.m_rhs.getVariables());
        return set;
    }

    @Override
    public int hashCode() {
        return 7 * this.m_lhs.hashCode() * this.m_rhs.hashCode();
    }

    public String toString() {
        String string2 = String.valueOf(this.m_lhs);
        String string3 = String.valueOf(this.m_rhs);
        return new StringBuilder(5 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("(").append(string2).append(" & ").append(string3).append(")").toString();
    }
}

