/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono.valuetracking;

import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.algorithms.mono.AbstractInstructionTracker;
import com.google.security.zynamics.reil.algorithms.mono.WalkInformation;
import com.google.security.zynamics.reil.algorithms.mono.interfaces.IInfluencingState;
import com.google.security.zynamics.reil.algorithms.mono.interfaces.ILattice;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.ValueTrackerElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.AddTransformer;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.AndTransformer;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.BiszTransformer;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.BshTransformer;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.JccTransformer;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.LdmTransformer;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.OrTransformer;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.StateCombiner;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.StmTransformer;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.StrTransformer;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.SubTransformer;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.UndefTransformer;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.transformers.XorTransformer;
import java.util.List;

public class ValueTrackerLattice
extends AbstractInstructionTracker<ValueTrackerElement>
implements ILattice<ValueTrackerElement, WalkInformation> {
    @Override
    protected ValueTrackerElement transformAdd(ReilInstruction instruction, ValueTrackerElement currentState, ValueTrackerElement state) {
        return AddTransformer.transform(instruction, state);
    }

    @Override
    protected ValueTrackerElement transformAnd(ReilInstruction instruction, ValueTrackerElement currentState, ValueTrackerElement state) {
        return AndTransformer.transform(instruction, state);
    }

    @Override
    protected ValueTrackerElement transformBinary(ReilInstruction instruction, ValueTrackerElement currentState, ValueTrackerElement state) {
        throw new IllegalStateException("Not yet implemented");
    }

    @Override
    protected ValueTrackerElement transformBisz(ReilInstruction instruction, ValueTrackerElement currentState, ValueTrackerElement combinedState) {
        return BiszTransformer.transform(instruction, combinedState);
    }

    @Override
    protected ValueTrackerElement transformBsh(ReilInstruction instruction, ValueTrackerElement currentState, ValueTrackerElement state) {
        return BshTransformer.transform(instruction, state);
    }

    @Override
    protected ValueTrackerElement transformJcc(ReilInstruction instruction, ValueTrackerElement currentState, ValueTrackerElement combinedState) {
        return JccTransformer.transform(combinedState);
    }

    @Override
    protected ValueTrackerElement transformLdm(ReilInstruction instruction, ValueTrackerElement currentState, ValueTrackerElement state) {
        return LdmTransformer.transform(instruction, state);
    }

    @Override
    protected ValueTrackerElement transformNop(ReilInstruction instruction, ValueTrackerElement currentState, ValueTrackerElement combinedState) {
        throw new IllegalStateException("Not yet implemented");
    }

    @Override
    protected ValueTrackerElement transformOr(ReilInstruction instruction, ValueTrackerElement currentState, ValueTrackerElement state) {
        return OrTransformer.transform(instruction, state);
    }

    @Override
    protected ValueTrackerElement transformStm(ReilInstruction instruction, ValueTrackerElement currentState, ValueTrackerElement combinedState) {
        return StmTransformer.transform(instruction, combinedState);
    }

    @Override
    protected ValueTrackerElement transformStr(ReilInstruction instruction, ValueTrackerElement currentState, ValueTrackerElement state) {
        return StrTransformer.transform(instruction, state);
    }

    @Override
    protected ValueTrackerElement transformSub(ReilInstruction instruction, ValueTrackerElement currentState, ValueTrackerElement state) {
        return SubTransformer.transform(instruction, state);
    }

    @Override
    protected ValueTrackerElement transformTrinary(ReilInstruction instruction, ValueTrackerElement currentState, ValueTrackerElement state) {
        throw new IllegalStateException();
    }

    @Override
    protected ValueTrackerElement transformUndef(ReilInstruction instruction, ValueTrackerElement currentState, ValueTrackerElement combinedState) {
        return UndefTransformer.transform(instruction, combinedState);
    }

    @Override
    protected ValueTrackerElement transformUnknown(ReilInstruction instruction, ValueTrackerElement currentState, ValueTrackerElement combinedState) {
        throw new IllegalStateException("Not yet implemented");
    }

    @Override
    protected ValueTrackerElement transformXor(ReilInstruction instruction, ValueTrackerElement currentState, ValueTrackerElement state) {
        return XorTransformer.transform(instruction, state);
    }

    @Override
    public ValueTrackerElement combine(List<IInfluencingState<ValueTrackerElement, WalkInformation>> states) {
        switch (states.size()) {
            case 0: {
                return new ValueTrackerElement();
            }
            case 1: {
                return states.get(0).getElement();
            }
        }
        return StateCombiner.combine(states);
    }
}

