/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono.valuetracking;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.ReilFunction;
import com.google.security.zynamics.reil.algorithms.mono.IStateVector;
import com.google.security.zynamics.reil.algorithms.mono.InstructionGraph;
import com.google.security.zynamics.reil.algorithms.mono.InstructionGraphNode;
import com.google.security.zynamics.reil.algorithms.mono.StateVector;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.ValueTrackerElement;
import com.google.security.zynamics.reil.algorithms.mono.valuetracking.ValueTrackerSolver;

public class ValueTracker {
    private static InstructionGraph createInitialGraph(ReilFunction reilFunction) {
        return InstructionGraph.create(reilFunction.getGraph());
    }

    private static StateVector<InstructionGraphNode, ValueTrackerElement> createInitialStateVector(InstructionGraph instructionGraph) {
        StateVector<InstructionGraphNode, ValueTrackerElement> stateVector = new StateVector<InstructionGraphNode, ValueTrackerElement>();
        for (InstructionGraphNode node : instructionGraph) {
            stateVector.setState(node, new ValueTrackerElement());
        }
        return stateVector;
    }

    public static IStateVector<InstructionGraphNode, ValueTrackerElement> track(ReilFunction function) {
        Preconditions.checkNotNull(function, "Error: function argument can not be null");
        InstructionGraph instructionGraph = ValueTracker.createInitialGraph(function);
        StateVector<InstructionGraphNode, ValueTrackerElement> stateVector = ValueTracker.createInitialStateVector(instructionGraph);
        ValueTrackerSolver tracker = new ValueTrackerSolver(instructionGraph, stateVector);
        return tracker.solve();
    }
}

