/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.algorithms.mono.IStateVector;
import com.google.security.zynamics.reil.algorithms.mono.interfaces.ILatticeElementMono1;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class StateVector<GraphNode, LatticeElement extends ILatticeElementMono1<LatticeElement>>
implements IStateVector<GraphNode, LatticeElement>,
Iterable<GraphNode> {
    private final Map<GraphNode, LatticeElement> mapping = new LinkedHashMap<GraphNode, LatticeElement>();

    @Override
    public LatticeElement getState(GraphNode node) {
        return (LatticeElement)((ILatticeElementMono1)this.mapping.get(Preconditions.checkNotNull(node, "Error: node argument can not be null")));
    }

    @Override
    public boolean hasState(GraphNode node) {
        return this.mapping.containsKey(Preconditions.checkNotNull(node, "Error: node argument can not be null"));
    }

    @Override
    public Iterator<GraphNode> iterator() {
        return this.mapping.keySet().iterator();
    }

    @Override
    public void setState(GraphNode node, LatticeElement element) {
        Preconditions.checkNotNull(node, "Error: node argument can not be null");
        Preconditions.checkNotNull(element, "Error: element argument can not be null");
        this.mapping.put(node, element);
    }

    @Override
    public int size() {
        return this.mapping.size();
    }

    public String toString() {
        return this.mapping.entrySet().stream().map(entry -> {
            String string2 = String.valueOf(entry.getKey());
            String string3 = String.valueOf(entry.getValue());
            return new StringBuilder(4 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" -> ").append(string3).toString();
        }).collect(Collectors.joining("\n", "[\n", "\n]"));
    }
}

