/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.algorithms.mono.interfaces.ILatticeElementMono1;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class RegisterSet
implements ILatticeElementMono1<RegisterSet>,
Iterable<String> {
    private final Set<String> registers = new HashSet<String>();

    public RegisterSet(List<String> registers) {
        this.registers.addAll(registers);
    }

    public RegisterSet(String ... registers) {
        for (String register2 : registers) {
            this.registers.add(Preconditions.checkNotNull(register2, "Error: register argument can not be null"));
        }
    }

    public static RegisterSet combine(RegisterSet lhs, List<String> rhs) {
        RegisterSet set = new RegisterSet(new String[0]);
        for (String string2 : lhs) {
            set.registers.add(string2);
        }
        for (String string2 : rhs) {
            set.registers.add(string2);
        }
        return set;
    }

    public static RegisterSet combine(RegisterSet lhs, RegisterSet rhs) {
        RegisterSet set = new RegisterSet(new String[0]);
        for (String string2 : lhs) {
            set.registers.add(string2);
        }
        for (String string2 : rhs) {
            set.registers.add(string2);
        }
        return set;
    }

    public static RegisterSet combine(RegisterSet state, String value) {
        RegisterSet set = new RegisterSet(new String[0]);
        for (String string2 : state) {
            set.registers.add(string2);
        }
        set.registers.add(value);
        return set;
    }

    public static RegisterSet remove(RegisterSet state, String value) {
        RegisterSet set = new RegisterSet(new String[0]);
        for (String string2 : state) {
            set.registers.add(string2);
        }
        set.registers.remove(value);
        return set;
    }

    public boolean contains(String string2) {
        return this.registers.contains(string2);
    }

    @Override
    public boolean equals(RegisterSet rhs) {
        return rhs.registers.equals(this.registers);
    }

    public Set<String> getRegisters() {
        return new HashSet<String>(this.registers);
    }

    @Override
    public Iterator<String> iterator() {
        return this.registers.iterator();
    }

    @Override
    public boolean lessThan(RegisterSet rhs) {
        return false;
    }

    public String toString() {
        return this.registers.stream().collect(Collectors.joining(", ", "{", "}"));
    }
}

