/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono;

import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.zylib.types.graphs.IGraphNode;
import java.util.ArrayList;
import java.util.List;

public final class OperandGraphNode
implements IGraphNode<OperandGraphNode> {
    private final ReilInstruction m_instruction;
    private final int m_index;
    private final List<OperandGraphNode> m_children = new ArrayList<OperandGraphNode>();
    private final List<OperandGraphNode> m_parents = new ArrayList<OperandGraphNode>();

    public OperandGraphNode(ReilInstruction instruction, int index) {
        this.m_instruction = instruction;
        this.m_index = index;
    }

    public static void link(OperandGraphNode parent, OperandGraphNode child) {
        parent.m_children.add(child);
        child.m_parents.add(parent);
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof OperandGraphNode)) {
            return false;
        }
        OperandGraphNode rhsNode = (OperandGraphNode)rhs;
        return this.m_index == rhsNode.getIndex() && this.m_instruction.equals(rhsNode.getInstruction());
    }

    @Override
    public List<OperandGraphNode> getChildren() {
        return new ArrayList<OperandGraphNode>(this.m_children);
    }

    public int getIndex() {
        return this.m_index;
    }

    public ReilInstruction getInstruction() {
        return this.m_instruction;
    }

    @Override
    public List<OperandGraphNode> getParents() {
        return new ArrayList<OperandGraphNode>(this.m_parents);
    }

    public String getValue() {
        switch (this.m_index) {
            case 0: {
                return this.m_instruction.getFirstOperand().getValue();
            }
            case 1: {
                return this.m_instruction.getSecondOperand().getValue();
            }
            case 2: {
                return this.m_instruction.getThirdOperand().getValue();
            }
        }
        throw new IllegalStateException("Error: Unknown operand index");
    }

    public int hashCode() {
        return this.m_index * this.m_instruction.hashCode();
    }

    public String toString() {
        String string2 = this.m_instruction.toString();
        int n2 = this.m_index;
        return new StringBuilder(12 + String.valueOf(string2).length()).append(string2).append("/").append(n2).toString();
    }
}

