/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.security.zynamics.reil.ReilBlock;
import com.google.security.zynamics.reil.ReilEdge;
import com.google.security.zynamics.reil.ReilGraph;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.algorithms.mono.OperandGraphEdge;
import com.google.security.zynamics.reil.algorithms.mono.OperandGraphNode;
import com.google.security.zynamics.reil.algorithms.mono.interfaces.ILatticeGraph;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.graphs.DirectedGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OperandGraph
extends DirectedGraph<OperandGraphNode, OperandGraphEdge>
implements ILatticeGraph<OperandGraphNode> {
    public OperandGraph(Set<OperandGraphNode> nodes, Set<OperandGraphEdge> edges) {
        super(new ArrayList<OperandGraphNode>(nodes), new ArrayList<OperandGraphEdge>(edges));
    }

    private static OperandGraph connectParts(ReilGraph graph, Map<ReilBlock, Pair<List<OperandGraphNode>, List<OperandGraphEdge>>> graphMap) {
        Pair unzipped = CollectionHelpers.unzip(graphMap.values());
        HashSet<OperandGraphNode> allNodes = Sets.newHashSet(CollectionHelpers.flatten(unzipped.first()));
        HashSet<OperandGraphEdge> allEdges = Sets.newHashSet(CollectionHelpers.flatten(unzipped.second()));
        for (ReilBlock block : graph) {
            Pair<List<OperandGraphNode>, List<OperandGraphEdge>> p2 = graphMap.get(block);
            List<OperandGraphNode> nodes = p2.first();
            List<ReilBlock> parents = OperandGraph.getParents(block);
            for (OperandGraphNode node : nodes) {
                if (node.getIndex() == 2) continue;
                OperandGraphNode definition = OperandGraph.findDefinition(node, block, graphMap, false);
                if (definition != null) {
                    OperandGraphEdge edge = new OperandGraphEdge(definition, node);
                    OperandGraphNode.link(definition, node);
                    allEdges.add(edge);
                    continue;
                }
                Set<OperandGraphNode> definitions = OperandGraph.findDefinitions(parents, node, graphMap, new HashSet<ReilBlock>());
                for (OperandGraphNode innerDefinition : definitions) {
                    OperandGraphEdge edge = new OperandGraphEdge(innerDefinition, node);
                    OperandGraphNode.link(innerDefinition, node);
                    allEdges.add(edge);
                }
            }
        }
        return new OperandGraph(allNodes, allEdges);
    }

    private static OperandGraphNode create(ReilInstruction instruction, int index, List<OperandGraphNode> nodes, List<OperandGraphEdge> edges, Map<String, OperandGraphNode> defines) {
        OperandGraphNode node = new OperandGraphNode(instruction, index);
        nodes.add(node);
        String operandString = node.getValue();
        if (defines.containsKey(node)) {
            OperandGraphNode source = defines.get(operandString);
            OperandGraphEdge edge = new OperandGraphEdge(source, node);
            edges.add(edge);
            OperandGraphNode.link(source, node);
        }
        return node;
    }

    private static Map<ReilBlock, Pair<List<OperandGraphNode>, List<OperandGraphEdge>>> createInitialMap(ReilGraph graph) {
        HashMap<ReilBlock, Pair<List<OperandGraphNode>, List<OperandGraphEdge>>> graphMap = new HashMap<ReilBlock, Pair<List<OperandGraphNode>, List<OperandGraphEdge>>>();
        for (ReilBlock block : graph) {
            ArrayList<OperandGraphNode> nodes = new ArrayList<OperandGraphNode>();
            ArrayList<OperandGraphEdge> edges = new ArrayList<OperandGraphEdge>();
            graphMap.put(block, new Pair(nodes, edges));
            HashMap<String, OperandGraphNode> defines = new HashMap<String, OperandGraphNode>();
            for (ReilInstruction instruction : block) {
                OperandGraphEdge edge;
                Integer mnemonic = instruction.getMnemonicCode();
                OperandGraphNode firstNode = null;
                OperandGraphNode secondNode = null;
                if (ReilHelpers.usesFirstOperand(mnemonic)) {
                    firstNode = OperandGraph.create(instruction, 0, nodes, edges, defines);
                }
                if (ReilHelpers.usesSecondOperand(mnemonic)) {
                    secondNode = OperandGraph.create(instruction, 1, nodes, edges, defines);
                }
                if (!ReilHelpers.writesThirdOperand(mnemonic)) continue;
                OperandGraphNode node = new OperandGraphNode(instruction, 2);
                nodes.add(node);
                defines.put(instruction.getThirdOperand().getValue(), node);
                if (firstNode != null) {
                    edge = new OperandGraphEdge(firstNode, node);
                    edges.add(edge);
                    OperandGraphNode.link(firstNode, node);
                }
                if (secondNode == null) continue;
                edge = new OperandGraphEdge(secondNode, node);
                edges.add(edge);
                OperandGraphNode.link(secondNode, node);
            }
        }
        return graphMap;
    }

    private static OperandGraphNode findDefinition(OperandGraphNode search, ReilBlock block, Map<ReilBlock, Pair<List<OperandGraphNode>, List<OperandGraphEdge>>> graphMap, boolean found) {
        String value = search.getValue();
        ArrayList<ReilInstruction> instructions = Lists.newArrayList(block.getInstructions());
        for (int i2 = instructions.size() - 1; i2 >= 0; --i2) {
            ReilInstruction instruction = (ReilInstruction)instructions.get(i2);
            if (search.getInstruction() == instruction) {
                found = true;
            }
            if (!found || !ReilHelpers.writesThirdOperand(instruction.getMnemonicCode()) || !instruction.getThirdOperand().getValue().equals(value)) continue;
            List<OperandGraphNode> nodes = graphMap.get(block).first();
            for (OperandGraphNode node : nodes) {
                if (node.getInstruction() != instruction || node.getIndex() != 2) continue;
                return node;
            }
        }
        return null;
    }

    private static Set<OperandGraphNode> findDefinitions(List<ReilBlock> parents, OperandGraphNode node, Map<ReilBlock, Pair<List<OperandGraphNode>, List<OperandGraphEdge>>> graphMap, HashSet<ReilBlock> visited) {
        HashSet<OperandGraphNode> definitions = new HashSet<OperandGraphNode>();
        for (ReilBlock reilBlock : parents) {
            if (visited.contains(reilBlock)) continue;
            visited.add(reilBlock);
            OperandGraphNode definition = OperandGraph.findDefinition(node, reilBlock, graphMap, true);
            if (definition != null) {
                definitions.add(definition);
                continue;
            }
            definitions.addAll(OperandGraph.findDefinitions(OperandGraph.getParents(reilBlock), node, graphMap, visited));
        }
        return definitions;
    }

    private static List<ReilBlock> getParents(ReilBlock block) {
        return block.getIncomingEdges().stream().map(ReilEdge::getSource).collect(Collectors.toList());
    }

    public static OperandGraph create(ReilGraph graph) {
        Map<ReilBlock, Pair<List<OperandGraphNode>, List<OperandGraphEdge>>> graphMap = OperandGraph.createInitialMap(graph);
        return OperandGraph.connectParts(graph, graphMap);
    }
}

