/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.algorithms.mono.IStateVector;
import com.google.security.zynamics.reil.algorithms.mono.ITransformationProvider;
import com.google.security.zynamics.reil.algorithms.mono.InfluencingState;
import com.google.security.zynamics.reil.algorithms.mono.StateVector;
import com.google.security.zynamics.reil.algorithms.mono.interfaces.IGraphWalker;
import com.google.security.zynamics.reil.algorithms.mono.interfaces.IInfluencingNode;
import com.google.security.zynamics.reil.algorithms.mono.interfaces.IInfluencingState;
import com.google.security.zynamics.reil.algorithms.mono.interfaces.ILattice;
import com.google.security.zynamics.reil.algorithms.mono.interfaces.ILatticeElementMono1;
import com.google.security.zynamics.reil.algorithms.mono.interfaces.ILatticeGraph;
import com.google.security.zynamics.reil.algorithms.mono.interfaces.IMonotoneDebugger;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MonotoneSolver<GraphNode, LatticeElement extends ILatticeElementMono1<LatticeElement>, ObjectType, Lattice extends ILattice<LatticeElement, ObjectType>> {
    private final ILatticeGraph<GraphNode> graph;
    private final Lattice lattice;
    private final IStateVector<GraphNode, LatticeElement> state;
    private final ITransformationProvider<GraphNode, LatticeElement> transformationList;
    private final IGraphWalker<GraphNode, ObjectType> walker;
    private final IMonotoneDebugger debugger;

    public MonotoneSolver(ILatticeGraph<GraphNode> graph, Lattice lattice, IStateVector<GraphNode, LatticeElement> startVector, ITransformationProvider<GraphNode, LatticeElement> transformationProvider, IGraphWalker<GraphNode, ObjectType> walker, IMonotoneDebugger debugger) {
        Preconditions.checkNotNull(graph, "Error: Graph argument can not be null");
        Preconditions.checkNotNull(lattice, "Error: Lattice argument can not be null");
        Preconditions.checkNotNull(startVector, "Error: Start vector argument can not be null");
        Preconditions.checkNotNull(transformationProvider, "Error: Transformation list argument can not be null");
        List<GraphNode> nodes = graph.getNodes();
        Preconditions.checkArgument(nodes.size() == startVector.size(), String.format("Error: Invalid start vector (%d states for %d nodes)", startVector.size(), nodes.size()));
        for (GraphNode node : nodes) {
            String string2 = String.valueOf(node);
            Preconditions.checkArgument(startVector.hasState(node), new StringBuilder(62 + String.valueOf(string2).length()).append("Error: Node ").append(string2).append(" does not have a state in the initial state vector").toString());
        }
        this.graph = graph;
        this.lattice = lattice;
        this.state = startVector;
        this.transformationList = transformationProvider;
        this.walker = walker;
        this.debugger = debugger;
    }

    private List<IInfluencingState<LatticeElement, ObjectType>> getStates(List<? extends IInfluencingNode<GraphNode, ObjectType>> nodes) {
        return nodes.stream().map(node -> new InfluencingState((ILatticeElementMono1)this.state.getState(node.getNode()), node.getObject())).collect(Collectors.toList());
    }

    private void transformState(Set<GraphNode> nodesToUpdate) {
        StateVector<GraphNode, ILatticeElementMono1> newState = new StateVector<GraphNode, ILatticeElementMono1>();
        LinkedHashSet<GraphNode> newNodesToUpdate = new LinkedHashSet<GraphNode>();
        for (GraphNode node : nodesToUpdate) {
            List<IInfluencingState<LatticeElement, ObjectType>> influencingStates = this.getStates(this.walker.getInfluencing(node));
            LatticeElement combinedState = this.lattice.combine(influencingStates);
            ILatticeElementMono1 transformedState = this.transformationList.transform(node, (ILatticeElementMono1)this.state.getState(node), (ILatticeElementMono1)combinedState);
            newState.setState(node, transformedState);
            if (this.debugger != null) {
                this.debugger.updatedState(node, influencingStates, transformedState);
            }
            if (!newState.getState((Object)node).equals((ILatticeElementMono1)this.state.getState(node))) {
                newNodesToUpdate.addAll(this.walker.getInfluenced(node));
            }
            if (!newState.getState((Object)node).lessThan((ILatticeElementMono1)this.state.getState(node))) continue;
            throw new IllegalStateException("Non-monotone transformation detected");
        }
        this.updateCurrentState(newState);
        if (this.debugger != null) {
            this.debugger.updatedState(this.state);
        }
        nodesToUpdate.clear();
        nodesToUpdate.addAll(newNodesToUpdate);
    }

    private void updateCurrentState(StateVector<GraphNode, LatticeElement> newState) {
        for (GraphNode node : newState) {
            this.state.setState(node, newState.getState((Object)node));
        }
    }

    public IStateVector<GraphNode, LatticeElement> solve() {
        LinkedHashSet<GraphNode> nodesToUpdate = new LinkedHashSet<GraphNode>(this.graph.getNodes());
        while (!nodesToUpdate.isEmpty()) {
            this.transformState(nodesToUpdate);
        }
        return this.state;
    }
}

