/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.algorithms.mono.InstructionGraphEdge;
import com.google.security.zynamics.zylib.types.graphs.DefaultEdge;
import com.google.security.zynamics.zylib.types.graphs.IGraphNode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class InstructionGraphNode
implements IGraphNode<InstructionGraphNode> {
    private final ReilInstruction instruction;
    private final List<InstructionGraphEdge> outgoingEdges = new ArrayList<InstructionGraphEdge>();
    private final List<InstructionGraphEdge> incomingEdges = new ArrayList<InstructionGraphEdge>();

    public InstructionGraphNode(ReilInstruction instruction) {
        Preconditions.checkNotNull(instruction, "Error: Instruction argument can not be null");
        this.instruction = instruction;
    }

    public static void link(InstructionGraphNode source, InstructionGraphNode target, InstructionGraphEdge edge) {
        Preconditions.checkNotNull(source, "Error: Source argument can not be null");
        Preconditions.checkNotNull(target, "Error: Target argument can not be null");
        Preconditions.checkNotNull(edge, "Error: Edge argument can not be null");
        source.outgoingEdges.add(edge);
        target.incomingEdges.add(edge);
    }

    @Override
    public List<InstructionGraphNode> getChildren() {
        return this.outgoingEdges.stream().map(DefaultEdge::getTarget).collect(Collectors.toList());
    }

    public List<InstructionGraphEdge> getIncomingEdges() {
        return new ArrayList<InstructionGraphEdge>(this.incomingEdges);
    }

    public ReilInstruction getInstruction() {
        return this.instruction;
    }

    public List<InstructionGraphEdge> getOutgoingEdges() {
        return new ArrayList<InstructionGraphEdge>(this.outgoingEdges);
    }

    @Override
    public List<InstructionGraphNode> getParents() {
        return this.incomingEdges.stream().map(DefaultEdge::getSource).collect(Collectors.toList());
    }

    public String toString() {
        return this.instruction.toString();
    }
}

