/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.security.zynamics.reil.ReilBlock;
import com.google.security.zynamics.reil.ReilEdge;
import com.google.security.zynamics.reil.ReilGraph;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.algorithms.mono.InstructionGraphEdge;
import com.google.security.zynamics.reil.algorithms.mono.InstructionGraphNode;
import com.google.security.zynamics.reil.algorithms.mono.interfaces.ILatticeGraph;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import com.google.security.zynamics.zylib.types.graphs.DirectedGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class InstructionGraph
extends DirectedGraph<InstructionGraphNode, InstructionGraphEdge>
implements ILatticeGraph<InstructionGraphNode> {
    public InstructionGraph(List<InstructionGraphNode> nodes, List<InstructionGraphEdge> edges) {
        super(nodes, edges);
    }

    public static InstructionGraph create(ReilGraph graph) {
        Preconditions.checkNotNull(graph, "Error: graph argument can not be null");
        ArrayList<InstructionGraphNode> nodes = new ArrayList<InstructionGraphNode>();
        ArrayList<InstructionGraphEdge> edges = new ArrayList<InstructionGraphEdge>();
        HashMap<ReilBlock, InstructionGraphNode> firstNodeMapping = new HashMap<ReilBlock, InstructionGraphNode>();
        HashMap<ReilBlock, InstructionGraphNode> lastNodeMapping = new HashMap<ReilBlock, InstructionGraphNode>();
        for (ReilBlock block : graph) {
            InstructionGraphNode lastNode = null;
            ReilInstruction lastInstruction = Iterables.getLast(block.getInstructions());
            for (ReilInstruction instruction : block) {
                InstructionGraphNode currentNode = new InstructionGraphNode(instruction);
                nodes.add(currentNode);
                if (instruction == lastInstruction) {
                    lastNodeMapping.put(block, currentNode);
                }
                if (!firstNodeMapping.containsKey(block)) {
                    firstNodeMapping.put(block, currentNode);
                }
                if (lastNode != null) {
                    InstructionGraphEdge edge = new InstructionGraphEdge(lastNode, currentNode, EdgeType.JUMP_UNCONDITIONAL);
                    edges.add(edge);
                    InstructionGraphNode.link(lastNode, currentNode, edge);
                }
                lastNode = currentNode;
            }
        }
        for (ReilBlock block : graph) {
            for (ReilEdge edge : block.getOutgoingEdges()) {
                InstructionGraphEdge newEdge = new InstructionGraphEdge((InstructionGraphNode)lastNodeMapping.get(block), (InstructionGraphNode)firstNodeMapping.get(edge.getTarget()), edge.getType());
                edges.add(newEdge);
                InstructionGraphNode.link((InstructionGraphNode)lastNodeMapping.get(block), (InstructionGraphNode)firstNodeMapping.get(edge.getTarget()), newEdge);
            }
        }
        return new InstructionGraph((List<InstructionGraphNode>)nodes, (List<InstructionGraphEdge>)edges);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\n");
        for (InstructionGraphNode node : this) {
            for (InstructionGraphEdge edge : node.getOutgoingEdges()) {
                String string2 = String.valueOf(node);
                String string3 = String.valueOf(edge.getTarget());
                stringBuilder.append(new StringBuilder(4 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" -> ").append(string3).toString());
                stringBuilder.append("\n");
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }
}

