/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.algorithms.mono;

import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.algorithms.mono.ITransformationProvider;
import com.google.security.zynamics.reil.algorithms.mono.InstructionGraphNode;
import com.google.security.zynamics.reil.algorithms.mono.interfaces.ILatticeElementMono1;

public abstract class AbstractInstructionTracker<LatticeElement extends ILatticeElementMono1<LatticeElement>>
implements ITransformationProvider<InstructionGraphNode, LatticeElement> {
    protected LatticeElement transformAdd(ReilInstruction instruction, LatticeElement currentState, LatticeElement incomingState) {
        return this.transformTrinary(instruction, currentState, incomingState);
    }

    protected LatticeElement transformAnd(ReilInstruction instruction, LatticeElement currentState, LatticeElement incomingState) {
        return this.transformTrinary(instruction, currentState, incomingState);
    }

    protected abstract LatticeElement transformBinary(ReilInstruction var1, LatticeElement var2, LatticeElement var3);

    protected LatticeElement transformBisz(ReilInstruction instruction, LatticeElement currentState, LatticeElement incomingState) {
        return this.transformBinary(instruction, currentState, incomingState);
    }

    protected LatticeElement transformBsh(ReilInstruction instruction, LatticeElement currentState, LatticeElement incomingState) {
        return this.transformTrinary(instruction, currentState, incomingState);
    }

    protected LatticeElement transformDiv(ReilInstruction instruction, LatticeElement currentState, LatticeElement incomingState) {
        return this.transformTrinary(instruction, currentState, incomingState);
    }

    protected abstract LatticeElement transformJcc(ReilInstruction var1, LatticeElement var2, LatticeElement var3);

    protected LatticeElement transformLdm(ReilInstruction instruction, LatticeElement currentState, LatticeElement incomingState) {
        return this.transformBinary(instruction, currentState, incomingState);
    }

    protected LatticeElement transformMod(ReilInstruction instruction, LatticeElement currentState, LatticeElement incomingState) {
        return this.transformTrinary(instruction, currentState, incomingState);
    }

    protected LatticeElement transformMul(ReilInstruction instruction, LatticeElement currentState, LatticeElement incomingState) {
        return this.transformTrinary(instruction, currentState, incomingState);
    }

    protected abstract LatticeElement transformNop(ReilInstruction var1, LatticeElement var2, LatticeElement var3);

    protected LatticeElement transformOr(ReilInstruction instruction, LatticeElement currentState, LatticeElement incomingState) {
        return this.transformTrinary(instruction, currentState, incomingState);
    }

    protected abstract LatticeElement transformStm(ReilInstruction var1, LatticeElement var2, LatticeElement var3);

    protected LatticeElement transformStr(ReilInstruction instruction, LatticeElement currentState, LatticeElement incomingState) {
        return this.transformBinary(instruction, currentState, incomingState);
    }

    protected LatticeElement transformSub(ReilInstruction instruction, LatticeElement currentState, LatticeElement incomingState) {
        return this.transformTrinary(instruction, currentState, incomingState);
    }

    protected abstract LatticeElement transformTrinary(ReilInstruction var1, LatticeElement var2, LatticeElement var3);

    protected abstract LatticeElement transformUndef(ReilInstruction var1, LatticeElement var2, LatticeElement var3);

    protected abstract LatticeElement transformUnknown(ReilInstruction var1, LatticeElement var2, LatticeElement var3);

    protected LatticeElement transformUnknownOpcode(ReilInstruction instruction, LatticeElement currentState, LatticeElement incomingState) {
        return this.transformTrinary(instruction, currentState, incomingState);
    }

    protected LatticeElement transformXor(ReilInstruction instruction, LatticeElement currentState, LatticeElement incomingState) {
        return this.transformTrinary(instruction, currentState, incomingState);
    }

    @Override
    public LatticeElement transform(InstructionGraphNode node, LatticeElement currentState, LatticeElement incomingState) {
        ReilInstruction instruction = node.getInstruction();
        switch (instruction.getMnemonic()) {
            case "add": {
                return this.transformAdd(instruction, currentState, incomingState);
            }
            case "and": {
                return this.transformAnd(instruction, currentState, incomingState);
            }
            case "bisz": {
                return this.transformBisz(instruction, currentState, incomingState);
            }
            case "bsh": {
                return this.transformBsh(instruction, currentState, incomingState);
            }
            case "div": {
                return this.transformDiv(instruction, currentState, incomingState);
            }
            case "jcc": {
                return this.transformJcc(instruction, currentState, incomingState);
            }
            case "ldm": {
                return this.transformLdm(instruction, currentState, incomingState);
            }
            case "mod": {
                return this.transformMod(instruction, currentState, incomingState);
            }
            case "mul": {
                return this.transformMul(instruction, currentState, incomingState);
            }
            case "nop": {
                return this.transformNop(instruction, currentState, incomingState);
            }
            case "or": {
                return this.transformOr(instruction, currentState, incomingState);
            }
            case "stm": {
                return this.transformStm(instruction, currentState, incomingState);
            }
            case "str": {
                return this.transformStr(instruction, currentState, incomingState);
            }
            case "sub": {
                return this.transformSub(instruction, currentState, incomingState);
            }
            case "undef": {
                return this.transformUndef(instruction, currentState, incomingState);
            }
            case "unkn": {
                return this.transformUnknown(instruction, currentState, incomingState);
            }
            case "xor": {
                return this.transformXor(instruction, currentState, incomingState);
            }
        }
        return this.transformUnknownOpcode(instruction, currentState, incomingState);
    }
}

