/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.OperandType;
import com.google.security.zynamics.reil.ReilOperandNode;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;

public class ReilOperand
implements IOperandTree {
    private final ReilOperandNode m_root;

    public ReilOperand(ReilOperandNode root) {
        this.m_root = Preconditions.checkNotNull(root);
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof ReilOperand)) {
            return false;
        }
        ReilOperand rhsOperand = (ReilOperand)rhs;
        return this.getType().equals((Object)rhsOperand.getType()) && this.getValue().equals(rhsOperand.getValue()) && this.getSize().equals((Object)rhsOperand.getSize());
    }

    @Override
    public ReilOperandNode getRootNode() {
        return this.m_root;
    }

    public OperandSize getSize() {
        return OperandSize.sizeStringToValue(this.m_root.getValue());
    }

    public OperandType getType() {
        return OperandType.getOperandType(this.getValue());
    }

    public String getValue() {
        return this.m_root.getChildren().get(0).getValue();
    }

    public int hashCode() {
        return this.getType().hashCode() * this.getValue().hashCode() * this.getSize().hashCode();
    }

    public String toString() {
        return this.getValue();
    }
}

