/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil;

import com.google.security.zynamics.reil.ReilBlock;
import com.google.security.zynamics.reil.ReilEdge;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import com.google.security.zynamics.zylib.types.graphs.DirectedGraph;
import java.util.List;

public class ReilGraph
extends DirectedGraph<ReilBlock, ReilEdge> {
    public ReilGraph(List<ReilBlock> nodes, List<ReilEdge> edges) {
        super(nodes, edges);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\n");
        for (ReilBlock block : this) {
            String string2 = String.valueOf(block);
            stringBuilder.append(new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append("\n").toString());
            for (ReilEdge edge : block.getOutgoingEdges()) {
                stringBuilder.append(block.getAddress());
                stringBuilder.append(" [");
                stringBuilder.append((Object)Enum.valueOf(EdgeType.class, edge.getType().toString()));
                stringBuilder.append(edge.getTarget().getAddress());
                stringBuilder.append("\n");
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }
}

