/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.ReilBlock;
import com.google.security.zynamics.zylib.disassembly.ICodeEdge;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import com.google.security.zynamics.zylib.types.graphs.IGraphEdge;

public class ReilEdge
implements IGraphEdge<ReilBlock>,
ICodeEdge<ReilBlock> {
    private final ReilBlock m_source;
    private final ReilBlock m_target;
    private final EdgeType m_type;

    public ReilEdge(ReilBlock source, ReilBlock target, EdgeType type) {
        this.m_source = Preconditions.checkNotNull(source, "Error: Source argument can't be null");
        this.m_target = Preconditions.checkNotNull(target, "Error: Target argument can't be null");
        this.m_type = type;
    }

    @Override
    public ReilBlock getSource() {
        return this.m_source;
    }

    @Override
    public ReilBlock getTarget() {
        return this.m_target;
    }

    @Override
    public EdgeType getType() {
        return this.m_type;
    }

    public String toString() {
        String string2 = String.valueOf(this.m_source.getAddress().toHexString());
        String string3 = String.valueOf(this.m_target.getAddress().toHexString());
        return new StringBuilder(4 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" -> ").append(string3).toString();
    }
}

