/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;

public enum OperandSize {
    EMPTY(0),
    BYTE(1),
    WORD(2),
    DWORD(4),
    QWORD(8),
    OWORD(16),
    ADDRESS(-1);

    private final int value;
    private static final ImmutableBiMap<String, OperandSize> regularOperandSizeMap;
    private static final ImmutableBiMap<String, OperandSize> completeOperandSizeMap;

    private OperandSize(int value) {
        this.value = value;
    }

    public static boolean isSizeString(String value) {
        return regularOperandSizeMap.containsKey(value);
    }

    public static OperandSize sizeStringToValue(String value) {
        return (OperandSize)((Object)completeOperandSizeMap.get(value));
    }

    public int getBitSize() {
        return this.getByteSize() * 8;
    }

    public int getByteSize() {
        Preconditions.checkArgument(this != ADDRESS, "Error: address does not have a size associated to it.");
        return this.value;
    }

    public String toSizeString() {
        return (String)((ImmutableMap)((Object)completeOperandSizeMap.inverse())).get((Object)this);
    }

    static {
        regularOperandSizeMap = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)new ImmutableBiMap.Builder().put("byte", (Object)BYTE)).put("word", (Object)WORD)).put("dword", (Object)DWORD)).put("qword", (Object)QWORD)).put("oword", (Object)OWORD)).build();
        completeOperandSizeMap = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)new ImmutableBiMap.Builder().putAll(regularOperandSizeMap)).put("", (Object)EMPTY)).put("address", (Object)ADDRESS)).build();
    }
}

