/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.common.config;

import java.awt.Color;
import java.util.Properties;

public class TypedPropertiesWrapper {
    private final Properties properties;
    private String keyPrefix;

    public TypedPropertiesWrapper() {
        this(new Properties());
    }

    public TypedPropertiesWrapper(Properties properties) {
        this.properties = properties;
        this.keyPrefix = "";
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setKeyPrefix(String prefix) {
        this.keyPrefix = prefix;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String string2 = String.valueOf(this.keyPrefix);
        String string3 = String.valueOf(key);
        return Boolean.valueOf(this.properties.getProperty(string3.length() != 0 ? string2.concat(string3) : new String(string2), String.valueOf(defaultValue)));
    }

    public void setBoolean(String key, boolean value) {
        String string2 = String.valueOf(this.keyPrefix);
        String string3 = String.valueOf(key);
        this.properties.setProperty(string3.length() != 0 ? string2.concat(string3) : new String(string2), String.valueOf(value));
    }

    public Color getColor(String key, Color defaultValue) {
        try {
            String string2 = String.valueOf(this.keyPrefix);
            String string3 = String.valueOf(key);
            return Color.decode(this.properties.getProperty(string3.length() != 0 ? string2.concat(string3) : new String(string2), String.valueOf(defaultValue.getRGB())));
        }
        catch (NumberFormatException e2) {
            return defaultValue;
        }
    }

    public void setColor(String key, Color value) {
        String string2 = String.valueOf(this.keyPrefix);
        String string3 = String.valueOf(key);
        this.properties.setProperty(string3.length() != 0 ? string2.concat(string3) : new String(string2), String.valueOf(value.getRGB()));
    }

    public int getInteger(String key, int defaultValue) {
        try {
            String string2 = String.valueOf(this.keyPrefix);
            String string3 = String.valueOf(key);
            return Integer.valueOf(this.properties.getProperty(string3.length() != 0 ? string2.concat(string3) : new String(string2), String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e2) {
            return defaultValue;
        }
    }

    public void setInteger(String key, int value) {
        String string2 = String.valueOf(this.keyPrefix);
        String string3 = String.valueOf(key);
        this.properties.setProperty(string3.length() != 0 ? string2.concat(string3) : new String(string2), String.valueOf(value));
    }

    public long getLong(String key, long defaultValue) {
        try {
            String string2 = String.valueOf(this.keyPrefix);
            String string3 = String.valueOf(key);
            return Long.valueOf(this.properties.getProperty(string3.length() != 0 ? string2.concat(string3) : new String(string2), String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e2) {
            return defaultValue;
        }
    }

    public void setLong(String key, long value) {
        String string2 = String.valueOf(this.keyPrefix);
        String string3 = String.valueOf(key);
        this.properties.setProperty(string3.length() != 0 ? string2.concat(string3) : new String(string2), String.valueOf(value));
    }

    public String getString(String key, String defaultValue) {
        String string2 = String.valueOf(this.keyPrefix);
        String string3 = String.valueOf(key);
        return this.properties.getProperty(string3.length() != 0 ? string2.concat(string3) : new String(string2), defaultValue);
    }

    public void setString(String key, String value) {
        String string2 = String.valueOf(this.keyPrefix);
        String string3 = String.valueOf(key);
        this.properties.setProperty(string3.length() != 0 ? string2.concat(string3) : new String(string2), value);
    }
}

