/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.zygraph;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.Settings.ZyGraphLayoutSettings;
import com.google.security.zynamics.zylib.gui.zygraph.layouters.CircularStyle;
import com.google.security.zynamics.zylib.gui.zygraph.layouters.HierarchicOrientation;
import com.google.security.zynamics.zylib.gui.zygraph.layouters.HierarchicStyle;
import com.google.security.zynamics.zylib.gui.zygraph.layouters.OrthogonalStyle;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.layouters.ZyGraphLayouter;
import y.f.c;

public final class ZyLayoutCreator {
    private ZyLayoutCreator() {
    }

    public static c getCircularLayout(ZyGraphLayoutSettings zyGraphLayoutSettings) {
        Preconditions.checkNotNull(zyGraphLayoutSettings, "IE00894: Settings argument can not be null");
        CircularStyle circularStyle = zyGraphLayoutSettings.getCircularSettings().getStyle();
        long l2 = zyGraphLayoutSettings.getCircularSettings().getMinimumNodeDistance();
        return ZyGraphLayouter.createCircularLayouter(circularStyle, l2);
    }

    public static c getHierarchicLayout(ZyGraphLayoutSettings zyGraphLayoutSettings) {
        Preconditions.checkNotNull(zyGraphLayoutSettings, "IE00895: Settings argument can not be null");
        HierarchicStyle hierarchicStyle = zyGraphLayoutSettings.getHierarchicalSettings().getStyle();
        long l2 = zyGraphLayoutSettings.getHierarchicalSettings().getMinimumLayerDistance();
        long l3 = zyGraphLayoutSettings.getHierarchicalSettings().getMinimumNodeDistance();
        long l4 = zyGraphLayoutSettings.getHierarchicalSettings().getMinimumEdgeDistance();
        long l5 = zyGraphLayoutSettings.getHierarchicalSettings().getMinimumNodeEdgeDistance();
        HierarchicOrientation hierarchicOrientation = zyGraphLayoutSettings.getHierarchicalSettings().getOrientation();
        return ZyGraphLayouter.createHierarchicalLayouter(hierarchicStyle, l2, l3, l4, l5, hierarchicOrientation);
    }

    public static c getOrthogonalLayout(ZyGraphLayoutSettings zyGraphLayoutSettings) {
        Preconditions.checkNotNull(zyGraphLayoutSettings, "IE00896: Settings argument can not be null");
        OrthogonalStyle orthogonalStyle = zyGraphLayoutSettings.getOrthogonalSettings().getStyle();
        long l2 = zyGraphLayoutSettings.getOrthogonalSettings().getMinimumNodeDistance();
        return ZyGraphLayouter.createOrthoLayouter(orthogonalStyle, l2, true);
    }
}

