/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.zygraph;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviEdge;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.functions.MoveFunctions;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.functions.ZoomFunctions;
import java.awt.geom.Point2D;

public final class ZyGraphHelpers {
    private ZyGraphHelpers() {
    }

    private static void focusView(ZyGraph zyGraph, double d2, Point2D point2D) {
        zyGraph.getView().focusView(d2, point2D, zyGraph.getSettings().getLayoutSettings().getAnimateLayout());
        zyGraph.updateViews();
    }

    public static void centerEdgeLabel(ZyGraph zyGraph, NaviEdge naviEdge, boolean bl2) {
        Preconditions.checkNotNull(zyGraph, "IE02101: Graph argument can not be null");
        Preconditions.checkNotNull(naviEdge, "IE02102: Edge argument can not be null");
        double d2 = zyGraph.getView().getZoom();
        if (!naviEdge.isVisible()) {
            NaviNode naviNode = (NaviNode)naviEdge.getSource();
            NaviNode naviNode2 = (NaviNode)naviEdge.getTarget();
            boolean bl3 = zyGraph.getSettings().getLayoutSettings().getAutomaticLayouting();
            zyGraph.getSettings().getLayoutSettings().setAutomaticLayouting(false);
            zyGraph.showNode(naviNode, true);
            zyGraph.showNode(naviNode2, true);
            zyGraph.getSettings().getLayoutSettings().setAutomaticLayouting(bl3);
        }
        if (bl2) {
            ZoomFunctions.zoomToEdgeLabel(zyGraph, naviEdge);
        } else {
            MoveFunctions.centerEdgeLable(zyGraph, naviEdge);
            ZyGraphHelpers.focusView(zyGraph, d2, zyGraph.getView().getCenter());
        }
    }

    public static void centerNode(ZyGraph zyGraph, NaviNode naviNode, boolean bl2) {
        Preconditions.checkNotNull(zyGraph, "IE02103: Graph argument can not be null");
        Preconditions.checkNotNull(naviNode, "IE02104: Node argument can not be null");
        double d2 = zyGraph.getView().getZoom();
        zyGraph.showNode(naviNode, true);
        if (bl2) {
            ZoomFunctions.zoomToNode(zyGraph, naviNode);
        } else {
            MoveFunctions.centerNode(zyGraph, naviNode);
            if (Double.compare(d2, zyGraph.getView().getZoom()) != 0) {
                ZyGraphHelpers.focusView(zyGraph, d2, zyGraph.getView().getCenter());
            }
        }
    }
}

