/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.zygraph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Loader.CViewSettingsGenerator;
import com.google.security.zynamics.binnavi.ZyGraph.INaviGraphListener;
import com.google.security.zynamics.binnavi.ZyGraph.IZyGraphInternals;
import com.google.security.zynamics.binnavi.ZyGraph.Implementations.CEdgeDrawingFunctions;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.IZyGraphLayoutSettingsListener;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.ZyGraphDisplaySettingsListenerAdapter;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.ZyGraphEdgeSettingsListenerAdapter;
import com.google.security.zynamics.binnavi.ZyGraph.Updaters.CEdgeUpdater;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CViewInserter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.Implementations.CLayoutFunctions;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.Implementations.CSettingsFunctions;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviEdge;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.Synchronizers.CViewGraphSynchronizer;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphConverters;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IEdgeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.proximity.MultiEdgeHider;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IRealizerUpdater;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyNodeRealizerListener;
import com.google.security.zynamics.zylib.gui.zygraph.wrappers.ViewableGraph;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.ZyGraph2DView;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.ZyEdgeRealizer;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.ZyNodeRealizer;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.ZyProximityNodeRealizer;
import java.awt.Component;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import y.c.d;
import y.c.p;
import y.c.r;
import y.i.U;

public class ZyGraph
extends AbstractZyGraph<NaviNode, NaviEdge> {
    private INaviView m_rawView;
    private final ZyGraphViewSettings m_settings;
    private final InternalDisplaySettingsListener m_settingsListener = new InternalDisplaySettingsListener();
    private final InternalEdgeSettingsListener m_edgeSettingsListener = new InternalEdgeSettingsListener();
    private final InternalLayoutSettingsListener m_layoutSettingsListener = new InternalLayoutSettingsListener();
    private final CViewGraphSynchronizer m_synchronizer;
    private final ListenerProvider<INaviGraphListener> m_listeners = new ListenerProvider();
    private boolean m_disableLayoutingInternally = false;

    public ZyGraph(INaviView iNaviView, LinkedHashMap<p, NaviNode> linkedHashMap, LinkedHashMap<d, NaviEdge> linkedHashMap2, ZyGraphViewSettings zyGraphViewSettings, ZyGraph2DView zyGraph2DView) {
        super(zyGraph2DView, linkedHashMap, linkedHashMap2, zyGraphViewSettings);
        this.m_rawView = Preconditions.checkNotNull(iNaviView, "IE00869: Argument view can't be null");
        this.m_settings = Preconditions.checkNotNull(zyGraphViewSettings, "IE00870: Settings argument can't be null");
        this.m_synchronizer = new CViewGraphSynchronizer(this, new GraphInternals(), this.getMappings());
        this.hideInvisibleElements();
        CLayoutFunctions.updateBackground(this);
        CEdgeDrawingFunctions.initializeEdgeDrawingMode(this);
        this.initializeListeners();
        this.initializeProximityBrowser();
        if (this.m_rawView.getType() == ViewType.Native && this.getGraph().f() >= this.m_settings.getProximitySettings().getProximityBrowsingActivationThreshold()) {
            this.m_settings.getProximitySettings().setProximityBrowsing(true);
        }
        this.updateMultipleEdgeState();
    }

    private void hideInvisibleElements() {
        U u2 = this.getGraph();
        for (INaviEdge iDatabaseObject : this.m_rawView.getGraph().getEdges()) {
            if (iDatabaseObject.isVisible()) continue;
            u2.a(this.getYEdge(iDatabaseObject));
        }
        for (INaviViewNode iNaviViewNode : this.m_rawView.getGraph()) {
            if (iNaviViewNode.isVisible()) continue;
            u2.a(this.getYNode(iNaviViewNode));
        }
    }

    private void initializeListeners() {
        this.m_settings.getDisplaySettings().addListener(this.m_settingsListener);
        this.m_settings.getEdgeSettings().addListener(this.m_edgeSettingsListener);
        this.m_settings.getLayoutSettings().addListener(this.m_layoutSettingsListener);
    }

    private void initializeProximityBrowser() {
        if (this.m_rawView.getType() == ViewType.Native && this.m_rawView.getNodeCount() >= this.m_settings.getProximitySettings().getProximityBrowsingActivationThreshold()) {
            this.initializeProximityBrowserNative();
        } else if (this.m_rawView.getType() == ViewType.NonNative && this.m_settings.getProximitySettings().getProximityBrowsing()) {
            this.initializeProximityBrowserNonNative();
        }
        if (this.m_rawView.getType() == ViewType.Native && this.visibleNodeCount() >= this.m_settings.getLayoutSettings().getAutolayoutDeactivationThreshold()) {
            this.m_settings.getLayoutSettings().setAutomaticLayouting(false);
        }
        if (this.m_settings.getLayoutSettings().getAutomaticLayouting()) {
            this.doLayout();
        }
    }

    private void initializeProximityBrowserNative() {
        List<NaviNode> list = GraphHelpers.getNodes(this);
        if (!list.isEmpty()) {
            NaviNode naviNode = (NaviNode)this.getMappings().getNode(this.getRawView().getGraph().getNodes().get(0));
            list.remove(naviNode);
            this.showNodes((Collection<NaviNode>)Lists.newArrayList(naviNode), (Collection<NaviNode>)list);
        }
    }

    private void initializeProximityBrowserNonNative() {
        this.m_disableLayoutingInternally = true;
        boolean bl2 = this.m_settings.getLayoutSettings().getAutomaticLayouting();
        this.m_settings.getLayoutSettings().setAutomaticLayouting(false);
        Set<NaviNode> set = GraphHelpers.getVisibleNodes(ViewableGraph.wrap(this));
        this.showNodes(set, false);
        this.m_settings.getLayoutSettings().setAutomaticLayouting(bl2);
        this.m_disableLayoutingInternally = false;
        if (this.m_rawView.getConfiguration().getId() == -1) {
            this.doLayout();
        }
    }

    private void removeListeners() {
        this.m_settings.getDisplaySettings().removeListener(this.m_settingsListener);
        this.m_settings.getEdgeSettings().removeListener(this.m_edgeSettingsListener);
        this.m_settings.getLayoutSettings().removeListener(this.m_layoutSettingsListener);
    }

    private void updateMultipleEdgeState() {
        if (this.m_settings.getEdgeSettings().getDisplayMultipleEdgesAsOne()) {
            MultiEdgeHider.hideMultipleEdgesInternal(this);
        } else {
            MultiEdgeHider.unhideMultipleEdgesInternal(this);
        }
    }

    public void addListener(INaviGraphListener iNaviGraphListener) {
        super.addListener(iNaviGraphListener);
        this.m_listeners.addListener(iNaviGraphListener);
        this.m_synchronizer.addListener(iNaviGraphListener);
    }

    public void addNodeModifier(final IZyNodeRealizerListener<NaviNode> iZyNodeRealizerListener) {
        this.iterate(new INodeCallback<NaviNode>(){

            @Override
            public IterationMode next(NaviNode naviNode) {
                naviNode.addNodeModifier(iZyNodeRealizerListener);
                return IterationMode.CONTINUE;
            }
        });
    }

    public void deleteNodes(List<NaviNode> list) {
        List<INaviViewNode> list2 = GraphConverters.convert(list);
        this.getGraph().r();
        this.getRawView().getContent().deleteNodes(list2);
        this.getGraph().s();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_synchronizer.dispose();
        this.removeListeners();
        this.iterate(new INodeCallback<NaviNode>(){

            @Override
            public IterationMode next(NaviNode naviNode) {
                IRealizerUpdater<ZyGraphNode<?>> iRealizerUpdater = naviNode.getRealizer().getUpdater();
                if (iRealizerUpdater != null) {
                    iRealizerUpdater.dispose();
                }
                return IterationMode.CONTINUE;
            }
        });
    }

    public INaviView getRawView() {
        return this.m_rawView;
    }

    @Override
    public Set<NaviNode> getSelectedNodes() {
        return this.m_synchronizer.getSelectedNodes();
    }

    @Override
    public ZyGraphViewSettings getSettings() {
        return this.m_settings;
    }

    public void removeListener(INaviGraphListener iNaviGraphListener) {
        super.removeListener(iNaviGraphListener);
        this.m_listeners.removeListener(iNaviGraphListener);
        this.m_synchronizer.removeListener(iNaviGraphListener);
    }

    public boolean save() {
        this.m_rawView.save();
        CSettingsFunctions.saveSettings(this.m_rawView, this.getView(), this.m_settings);
        return true;
    }

    public INaviView saveAs(IViewContainer iViewContainer, String string2, String string3) {
        Object object;
        Preconditions.checkNotNull(iViewContainer, "IE00871: Container argument can not be null");
        Preconditions.checkNotNull(string2, "IE00872: Name argument can not be null");
        Preconditions.checkNotNull(string3, "IE00899: Description argument can not be null");
        INaviView iNaviView = this.m_rawView;
        INaviView iNaviView2 = iViewContainer.createView(string2, string3);
        CViewInserter.insertView(iNaviView, iNaviView2);
        List<INaviViewNode> list = iNaviView.getGraph().getNodes();
        List<INaviViewNode> list2 = iNaviView2.getGraph().getNodes();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object = list2.get(i2);
            NaviNode naviNode = (NaviNode)this.getMappings().getNode(list.get(i2));
            this.getMappings().setNode(object, naviNode);
            naviNode.setRawNode(object);
            for (INaviGraphListener iNaviGraphListener : this.m_listeners) {
                try {
                    iNaviGraphListener.changedModel(this, naviNode);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
        List<INaviEdge> list3 = iNaviView.getGraph().getEdges();
        object = iNaviView2.getGraph().getEdges();
        for (int i3 = 0; i3 < list3.size(); ++i3) {
            INaviEdge iNaviEdge = (INaviEdge)object.get(i3);
            NaviEdge naviEdge = (NaviEdge)this.getMappings().getEdge(list3.get(i3));
            assert (naviEdge != null);
            this.getMappings().setEdge(iNaviEdge, naviEdge);
            ZyEdgeRealizer zyEdgeRealizer = naviEdge.getRealizer();
            zyEdgeRealizer.setUpdater(new CEdgeUpdater(iNaviEdge));
            naviEdge.setRawEdge(iNaviEdge);
        }
        this.removeListeners();
        iNaviView2.save();
        CSettingsFunctions.saveSettings(iNaviView2, this.getView(), this.m_settings);
        this.m_rawView = iNaviView2;
        this.initializeListeners();
        this.m_synchronizer.reset();
        for (INaviGraphListener iNaviGraphListener : this.m_listeners) {
            try {
                iNaviGraphListener.changedView(iNaviView, iNaviView2);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        iNaviView.close();
        return this.m_rawView;
    }

    @Override
    public void showNodes(Collection<NaviNode> collection, Collection<NaviNode> collection2) {
        this.m_synchronizer.setMultiEdgeUpdatingEnabled(false);
        super.showNodes(collection, collection2);
        this.m_synchronizer.setMultiEdgeUpdatingEnabled(true);
    }

    public int visibleNodeCount() {
        return CollectionHelpers.countIf(new r(this.getGraph().o()), new ICollectionFilter<p>(){

            @Override
            public boolean qualifies(p p2) {
                return !(ZyGraph.this.getGraph().t(p2) instanceof ZyProximityNodeRealizer);
            }
        });
    }

    public void workAroundCase874() {
        this.getView().setCenter(CViewSettingsGenerator.createDoubleSetting(this.getSettings().rawSettings, "view_center_x", 0.0), CViewSettingsGenerator.createDoubleSetting(this.getSettings().rawSettings, "view_center_y", 0.0));
        this.getView().setWorldRect(CViewSettingsGenerator.createIntegerSetting(this.getSettings().rawSettings, "world_rect_x", 0), CViewSettingsGenerator.createIntegerSetting(this.getSettings().rawSettings, "world_rect_y", 0), CViewSettingsGenerator.createIntegerSetting(this.getSettings().rawSettings, "world_rect_width", 800), CViewSettingsGenerator.createIntegerSetting(this.getSettings().rawSettings, "world_rect_height", 600));
        this.getView().setZoom(CViewSettingsGenerator.createDoubleSetting(this.getSettings().rawSettings, "zoom", 1.0));
        this.updateViews();
    }

    public String getViewName() {
        return this.getView().getName();
    }

    public Component getViewAsComponent() {
        return this.getView();
    }

    public NaviNode getRawNodeFromIndex(int n2) {
        return (NaviNode)this.getNode(this.getRawView().getGraph().getNodes().get(n2));
    }

    public void makeRawNodeVisibleAndSelect(int n2) {
        INaviViewNode iNaviViewNode = this.getRawView().getGraph().getNodes().get(n2);
        NaviNode naviNode = (NaviNode)this.getNode(iNaviViewNode);
        if (!iNaviViewNode.isVisible() && !this.getSettings().getProximitySettings().getProximityBrowsingFrozen()) {
            iNaviViewNode.setVisible(true);
        }
        this.selectNode(naviNode, !iNaviViewNode.isSelected());
    }

    private class InternalLayoutSettingsListener
    implements IZyGraphLayoutSettingsListener {
        private InternalLayoutSettingsListener() {
        }

        @Override
        public void changedAutomaticLayouting(boolean bl2) {
            if (ZyGraph.this.m_settings.getLayoutSettings().getAutomaticLayouting() && !ZyGraph.this.m_disableLayoutingInternally) {
                ZyGraph.this.doLayout();
            }
        }
    }

    private class InternalEdgeSettingsListener
    extends ZyGraphEdgeSettingsListenerAdapter {
        private InternalEdgeSettingsListener() {
        }

        @Override
        public void changedDisplayMultipleEdgesAsOne(boolean bl2) {
            ZyGraph.this.updateMultipleEdgeState();
        }

        @Override
        public void changedDrawSelectedBends(final boolean bl2) {
            ZyGraph.this.iterateEdges(new IEdgeCallback<NaviEdge>(){

                @Override
                public IterationMode nextEdge(NaviEdge naviEdge) {
                    naviEdge.getRealizer().setDrawBends(bl2);
                    return IterationMode.CONTINUE;
                }
            });
            ZyGraph.this.updateViews();
        }
    }

    private class InternalDisplaySettingsListener
    extends ZyGraphDisplaySettingsListenerAdapter {
        private InternalDisplaySettingsListener() {
        }

        @Override
        public void changedFunctionNodeInformation(boolean bl2) {
            for (NaviNode naviNode : ZyGraph.this.getMappings().getNodes()) {
                if (!(naviNode.getRawNode() instanceof INaviFunctionNode)) continue;
                ((ZyNodeRealizer)ZyGraph.this.getGraph().t(naviNode.getNode())).regenerate();
            }
            ZyGraph.this.updateViews();
        }

        @Override
        public void changedShowMemoryAddresses(IDebugger iDebugger, boolean bl2) {
            for (NaviNode naviNode : ZyGraph.this.getMappings().getNodes()) {
                ((ZyNodeRealizer)ZyGraph.this.getGraph().t(naviNode.getNode())).regenerate();
            }
            ZyGraph.this.updateViews();
        }
    }

    private class GraphInternals
    implements IZyGraphInternals {
        private GraphInternals() {
        }

        @Override
        public void notifyNodeDeleted() {
            ZyGraph.this.notifyDeletionListeners();
        }

        @Override
        public void removeEdge(NaviEdge naviEdge) {
            if (naviEdge.getEdge().a() != null) {
                ZyGraph.this.getGraph().a(naviEdge.getEdge());
            }
            ZyGraph.this.getMappings().removeEdge(naviEdge);
            NaviNode.unlink((NaviNode)naviEdge.getSource(), (NaviNode)naviEdge.getTarget());
        }

        @Override
        public void removeNode(NaviNode naviNode) {
            ZyGraph.this.removeNode(naviNode);
        }
    }
}

