/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.zygraph.Updaters.GroupNodes;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.ZyGroupNodeBuilder;
import com.google.security.zynamics.binnavi.disassembly.CNaviGroupNodeListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.CNaviViewNodeListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.Updaters.GroupNodes.CTagUpdater;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IRealizerUpdater;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.IZyNodeRealizer;
import java.util.Iterator;
import java.util.List;
import y.i.U;

public final class CGroupNodeUpdater
implements IRealizerUpdater<NaviNode> {
    private final U m_graph;
    private final INaviGroupNode m_node;
    private IZyNodeRealizer m_realizer;
    private final CTagUpdater m_listener;
    private final InternalViewNodeListener m_internalViewNodeListener = new InternalViewNodeListener();
    private final InternalGroupNodeListener m_internalGroupNodeListener = new InternalGroupNodeListener();

    public CGroupNodeUpdater(ZyGraph zyGraph, INaviGroupNode iNaviGroupNode) {
        Preconditions.checkNotNull(zyGraph, "IE00992: Graph argument can't be null");
        Preconditions.checkNotNull(iNaviGroupNode, "IE00993: Node argument can't be null");
        this.m_graph = zyGraph.getGraph();
        this.m_node = iNaviGroupNode;
        this.m_listener = new CTagUpdater(zyGraph.getGraph());
        this.initializeListeners();
    }

    private void initializeListeners() {
        this.m_node.addListener(this.m_internalViewNodeListener);
        this.m_node.addGroupListener(this.m_internalGroupNodeListener);
        Iterator<CTag> iterator = this.m_node.getTagsIterator();
        while (iterator.hasNext()) {
            iterator.next().addListener(this.m_listener);
        }
    }

    private void rebuildNode() {
        this.m_realizer.regenerate();
        this.m_graph.S();
    }

    private void removeListeners() {
        Iterator<CTag> iterator = this.m_node.getTagsIterator();
        while (iterator.hasNext()) {
            iterator.next().removeListener(this.m_listener);
        }
        this.m_node.removeListener(this.m_internalViewNodeListener);
        this.m_node.removeGroupListener(this.m_internalGroupNodeListener);
    }

    @Override
    public void dispose() {
        this.removeListeners();
    }

    @Override
    public void generateContent(IZyNodeRealizer iZyNodeRealizer, ZyLabelContent zyLabelContent) {
        ZyGroupNodeBuilder.buildContent(zyLabelContent, this.m_node);
    }

    @Override
    public void setRealizer(IZyNodeRealizer iZyNodeRealizer) {
        Preconditions.checkNotNull(iZyNodeRealizer, "IE01740: Realizer argument can't be null");
        this.m_realizer = iZyNodeRealizer;
    }

    private class InternalViewNodeListener
    extends CNaviViewNodeListenerAdapter {
        private InternalViewNodeListener() {
        }

        @Override
        public void taggedNode(INaviViewNode iNaviViewNode, CTag cTag) {
            cTag.addListener(CGroupNodeUpdater.this.m_listener);
            CGroupNodeUpdater.this.rebuildNode();
        }

        @Override
        public void untaggedNodes(INaviViewNode iNaviViewNode, List<CTag> list) {
            for (CTag cTag : list) {
                cTag.removeListener(CGroupNodeUpdater.this.m_listener);
            }
            CGroupNodeUpdater.this.rebuildNode();
        }
    }

    private class InternalGroupNodeListener
    extends CNaviGroupNodeListenerAdapter {
        private InternalGroupNodeListener() {
        }

        @Override
        public void appendedGroupNodeComment(INaviGroupNode iNaviGroupNode, IComment iComment) {
            CGroupNodeUpdater.this.rebuildNode();
        }

        @Override
        public void changedState(INaviGroupNode iNaviGroupNode) {
            CGroupNodeUpdater.this.rebuildNode();
        }

        @Override
        public void deletedGroupNodeComment(INaviGroupNode iNaviGroupNode, IComment iComment) {
            CGroupNodeUpdater.this.rebuildNode();
        }

        @Override
        public void editedGroupNodeComment(INaviGroupNode iNaviGroupNode, IComment iComment) {
            CGroupNodeUpdater.this.rebuildNode();
        }

        @Override
        public void initializedGroupNodeComment(INaviGroupNode iNaviGroupNode, List<IComment> list) {
            CGroupNodeUpdater.this.rebuildNode();
        }
    }
}

