/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.zygraph.Updaters;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.ZyTextNodeBuilder;
import com.google.security.zynamics.binnavi.disassembly.CNaviTextNodeListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.INaviTextNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IRealizerUpdater;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.IZyNodeRealizer;
import y.i.U;

public final class CTextNodeUpdater
implements IRealizerUpdater<NaviNode> {
    private final U m_graph;
    private final INaviTextNode m_node;
    private IZyNodeRealizer m_realizer;
    private final InternalListener m_listener = new InternalListener();

    public CTextNodeUpdater(ZyGraph zyGraph, INaviTextNode iNaviTextNode) {
        Preconditions.checkNotNull(zyGraph, "IE00994: Graph argument can't be null");
        Preconditions.checkNotNull(iNaviTextNode, "IE00995: Code node argument can't be null");
        this.m_graph = zyGraph.getGraph();
        this.m_node = iNaviTextNode;
        this.initializeListeners();
    }

    private void initializeListeners() {
        this.m_node.addListener(this.m_listener);
    }

    private void removeListeners() {
        this.m_node.removeListener(this.m_listener);
    }

    @Override
    public void dispose() {
        this.removeListeners();
    }

    @Override
    public void generateContent(IZyNodeRealizer iZyNodeRealizer, ZyLabelContent zyLabelContent) {
        ZyTextNodeBuilder.buildContent(zyLabelContent, this.m_node);
    }

    @Override
    public void setRealizer(IZyNodeRealizer iZyNodeRealizer) {
        this.m_realizer = iZyNodeRealizer;
    }

    private class InternalListener
    extends CNaviTextNodeListenerAdapter {
        private InternalListener() {
        }

        @Override
        public void appendedTextNodeComment(INaviTextNode iNaviTextNode, IComment iComment) {
            CTextNodeUpdater.this.m_realizer.regenerate();
            CTextNodeUpdater.this.m_graph.S();
        }

        @Override
        public void deletedTextNodeComment(INaviTextNode iNaviTextNode, IComment iComment) {
            CTextNodeUpdater.this.m_realizer.regenerate();
            CTextNodeUpdater.this.m_graph.S();
        }

        @Override
        public void editedTextNodeComment(INaviTextNode iNaviTextNode, IComment iComment) {
            CTextNodeUpdater.this.m_realizer.regenerate();
            CTextNodeUpdater.this.m_graph.S();
        }
    }
}

