/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.zygraph.Builders;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.CGraphBuilderReporter;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.GraphBuilderEvents;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.IGraphBuilderListener;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.Builders.ZyEdgeBuilder;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.Builders.ZyGraphNodeBuilder;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviEdge;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import y.c.d;
import y.i.U;
import y.i.a.k;
import y.i.a.p;

public final class ZyGraphBuilder {
    private final LinkedHashMap<y.c.p, NaviNode> m_ynodeToNodeMap = new LinkedHashMap();
    private final LinkedHashMap<d, NaviEdge> m_yedgeToEdgeMap = new LinkedHashMap();
    private final ListenerProvider<IGraphBuilderListener> m_listeners = new ListenerProvider();
    private final CGraphBuilderReporter m_loadReporter = new CGraphBuilderReporter(this.m_listeners);

    private static void setupGroupNodes(Iterable<INaviViewNode> iterable, U u2, Map<INaviViewNode, y.c.p> map) {
        for (INaviViewNode iNaviViewNode : iterable) {
            if (iNaviViewNode.getParentGroup() == null) continue;
            y.c.p p2 = map.get(iNaviViewNode);
            y.c.p p3 = map.get(iNaviViewNode.getParentGroup());
            u2.C().c(p2, p3);
        }
    }

    private void checkCancellation(GraphBuilderEvents graphBuilderEvents) {
        if (!this.m_loadReporter.report(graphBuilderEvents)) {
            throw new LoadCancelledException();
        }
    }

    private void convertEdges(Collection<INaviEdge> collection, U u2, Map<INaviViewNode, y.c.p> map, boolean bl2) {
        for (INaviEdge iNaviEdge : collection) {
            NaviNode naviNode = this.m_ynodeToNodeMap.get(map.get(iNaviEdge.getSource()));
            NaviNode naviNode2 = this.m_ynodeToNodeMap.get(map.get(iNaviEdge.getTarget()));
            Pair<d, NaviEdge> pair = ZyEdgeBuilder.convertEdge(iNaviEdge, naviNode, naviNode2, u2, bl2);
            this.m_yedgeToEdgeMap.put(pair.first(), pair.second());
        }
    }

    private void convertNodes(Collection<INaviViewNode> collection, U u2, Map<INaviViewNode, y.c.p> map, ZyGraphViewSettings zyGraphViewSettings) {
        for (INaviViewNode iNaviViewNode : collection) {
            Pair<y.c.p, NaviNode> pair = ZyGraphNodeBuilder.convertNode(iNaviViewNode, u2, zyGraphViewSettings);
            map.put(iNaviViewNode, pair.first());
            this.m_ynodeToNodeMap.put(pair.first(), pair.second());
        }
    }

    public void addListener(IGraphBuilderListener iGraphBuilderListener) {
        this.m_listeners.addListener(iGraphBuilderListener);
    }

    public U convert(Collection<INaviViewNode> collection, Collection<INaviEdge> collection2, ZyGraphViewSettings zyGraphViewSettings, boolean bl2) {
        Preconditions.checkNotNull(collection, "IE00905: View can not be null");
        Preconditions.checkNotNull(collection2, "IE00906: Edges argument can not be null");
        if (!this.m_loadReporter.report(GraphBuilderEvents.Started)) {
            throw new LoadCancelledException();
        }
        this.m_loadReporter.start();
        U u2 = new U();
        p p2 = new p(u2);
        u2.a(p2);
        p2.a(new k.a());
        this.checkCancellation(GraphBuilderEvents.InitializedGraph);
        HashMap<INaviViewNode, y.c.p> hashMap = new HashMap<INaviViewNode, y.c.p>();
        this.convertNodes(collection, u2, hashMap, zyGraphViewSettings);
        this.checkCancellation(GraphBuilderEvents.ConvertedNodes);
        this.convertEdges(collection2, u2, hashMap, bl2);
        this.checkCancellation(GraphBuilderEvents.ConvertedEdges);
        ZyGraphBuilder.setupGroupNodes(collection, u2, hashMap);
        this.checkCancellation(GraphBuilderEvents.CreatedGroupNodes);
        this.checkCancellation(GraphBuilderEvents.Finished);
        return u2;
    }

    public int getBuildStep() {
        return this.m_loadReporter.getStep();
    }

    public LinkedHashMap<d, NaviEdge> getEdgeMap() {
        return this.m_yedgeToEdgeMap;
    }

    public LinkedHashMap<y.c.p, NaviNode> getNodeMap() {
        return this.m_ynodeToNodeMap;
    }

    public void removeListener(IGraphBuilderListener iGraphBuilderListener) {
        this.m_listeners.removeListener(iGraphBuilderListener);
    }
}

