/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.disassembly.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import y.a.c;
import y.c.d;
import y.c.e;
import y.c.h;
import y.c.p;

public final class TypeDependenceGraph {
    private final h containedRelation = new h();
    private final BiMap<BaseType, p> containedRelationMap = HashBiMap.create();

    public TypeDependenceGraph(ImmutableCollection<BaseType> immutableCollection, ImmutableCollection<TypeMember> immutableCollection2) {
        Preconditions.checkNotNull(immutableCollection, "IE02761: Types argument can not be null.");
        Preconditions.checkNotNull(immutableCollection2, "Error: Members argument can not be null.");
        for (BaseType baseType : immutableCollection) {
            this.addType(baseType);
        }
        this.initializeMembers(immutableCollection2);
    }

    private static p createTypeNode(BaseType baseType, h h2, BiMap<BaseType, p> biMap) {
        p p2 = (p)biMap.get(baseType);
        if (p2 == null) {
            p p3 = h2.d();
            biMap.put(baseType, p3);
            return p3;
        }
        return p2;
    }

    private ImmutableSet<BaseType> deleteMember(BaseType baseType, BaseType baseType2) {
        p p2 = (p)this.containedRelationMap.get(baseType);
        p p3 = (p)this.containedRelationMap.get(baseType2);
        d d2 = p3.a(p2);
        this.containedRelation.a(d2);
        return this.determineDependentTypes(baseType);
    }

    public DependenceResult addMember(BaseType baseType, BaseType baseType2) {
        Preconditions.checkNotNull(baseType, "IE02762: Parent type can not be null.");
        Preconditions.checkNotNull(baseType2, "IE02763: Member type can not be null.");
        p p2 = (p)Preconditions.checkNotNull(this.containedRelationMap.get(baseType2), "Type node for member type must exist prior to adding a member.");
        p p3 = (p)Preconditions.checkNotNull(this.containedRelationMap.get(baseType), "Type node for member parent must exist prior to adding a member");
        if (this.willCreateCycle(baseType, baseType2)) {
            return new DependenceResult(false, ImmutableSet.of());
        }
        this.containedRelation.a(p2, p3);
        TypeSearch typeSearch = new TypeSearch(this.containedRelationMap.inverse());
        typeSearch.start(this.containedRelation, (p)this.containedRelationMap.get(baseType));
        return new DependenceResult(true, typeSearch.getDependentTypes());
    }

    private void initializeMembers(ImmutableCollection<TypeMember> immutableCollection) {
        Preconditions.checkNotNull(immutableCollection, "Error: members argument can not be null.");
        for (TypeMember typeMember : immutableCollection) {
            p p2 = (p)this.containedRelationMap.get(typeMember.getBaseType());
            p p3 = (p)this.containedRelationMap.get(typeMember.getParentType());
            this.containedRelation.a(p2, p3);
        }
        if (!c.a(this.containedRelation, true).isEmpty()) {
            throw new IllegalStateException("Error: Dependence graph has cycles after initialization.");
        }
    }

    public void addType(BaseType baseType) {
        Preconditions.checkNotNull(baseType, "IE02764: Base type can not be null.");
        TypeDependenceGraph.createTypeNode(baseType, this.containedRelation, this.containedRelationMap);
    }

    public ImmutableSet<BaseType> deleteMember(TypeMember typeMember) {
        Preconditions.checkNotNull(typeMember, "IE02765: Member can not be null.");
        return this.deleteMember(typeMember.getParentType(), typeMember.getBaseType());
    }

    public ImmutableSet<BaseType> deleteType(BaseType baseType) {
        Preconditions.checkNotNull(baseType, "IE02766: Base type can not be null.");
        p p2 = (p)this.containedRelationMap.get(baseType);
        Preconditions.checkNotNull(p2, "Unable to delete type: corresponding node not found in the dependence graph.");
        ImmutableSet<BaseType> immutableSet = this.determineDependentTypes(baseType);
        this.containedRelation.a(p2);
        this.containedRelationMap.remove(baseType);
        return immutableSet;
    }

    public ImmutableSet<BaseType> determineDependentTypes(BaseType baseType) {
        Preconditions.checkNotNull(baseType, "Error: Base type can not be null.");
        p p2 = (p)this.containedRelationMap.get(baseType);
        TypeSearch typeSearch = new TypeSearch(this.containedRelationMap.inverse());
        typeSearch.start(this.containedRelation, p2);
        return typeSearch.getDependentTypes();
    }

    public boolean isTypeContainedIn(BaseType baseType, BaseType baseType2) {
        Preconditions.checkNotNull(baseType, "Error: Containing type can not be null.");
        Preconditions.checkNotNull(baseType, "Error: Base type can not be null.");
        return this.determineDependentTypes(baseType2).contains(baseType);
    }

    public DependenceResult updateMember(BaseType baseType, BaseType baseType2, BaseType baseType3) {
        Preconditions.checkNotNull(baseType, "IE02767: Parent type can not be null.");
        Preconditions.checkNotNull(baseType2, "IE02768: Old member type can not be null.");
        Preconditions.checkNotNull(baseType3, "IE02769: New member type can not be null.");
        ImmutableSet<BaseType> immutableSet = this.determineDependentTypes(baseType);
        if (immutableSet.contains(baseType)) {
            return new DependenceResult(false, immutableSet);
        }
        this.deleteMember(baseType, baseType2);
        this.addMember(baseType, baseType3);
        return new DependenceResult(true, immutableSet);
    }

    public ImmutableSet<BaseType> updateType(BaseType baseType) {
        Preconditions.checkNotNull(baseType, "IE02770: Base type can not be null.");
        return this.determineDependentTypes(baseType);
    }

    public boolean willCreateCycle(BaseType baseType, BaseType baseType2) {
        Preconditions.checkNotNull(baseType, "Error: Containing type can not be null.");
        Preconditions.checkNotNull(baseType2, "Error: Member type can not be null.");
        if (baseType == baseType2) {
            return true;
        }
        HashSet<BaseType> hashSet = Sets.newHashSet(this.determineDependentTypes(baseType));
        hashSet.remove(baseType);
        p p2 = (p)this.containedRelationMap.get(baseType2);
        LinkedList<d> linkedList = new LinkedList<d>();
        Object object = p2.k();
        while (object.f()) {
            linkedList.add((d)object.d());
            object.g();
        }
        object = new HashSet();
        while (!linkedList.isEmpty()) {
            d d2 = (d)linkedList.poll();
            p p3 = d2.c();
            BaseType baseType3 = (BaseType)this.containedRelationMap.inverse().get(p3);
            if (hashSet.contains(baseType3)) {
                return true;
            }
            if (!object.contains(p3)) {
                e e2 = p3.k();
                while (e2.f()) {
                    linkedList.add((d)e2.d());
                    e2.g();
                }
            }
            object.add(p3);
        }
        return false;
    }

    public class DependenceResult {
        private final boolean isValid;
        private final ImmutableSet<BaseType> affectedTypes;

        public DependenceResult(boolean bl2, ImmutableSet<BaseType> immutableSet) {
            this.isValid = bl2;
            this.affectedTypes = immutableSet;
        }

        public ImmutableSet<BaseType> getAffectedTypes() {
            return this.affectedTypes;
        }

        public boolean isValid() {
            return this.isValid;
        }
    }

    private static class TypeSearch
    extends y.a.e {
        private final ImmutableSet.Builder<BaseType> builder = ImmutableSet.builder();
        private final Map<p, BaseType> nodesToTypes;

        public TypeSearch(Map<p, BaseType> map) {
            this.nodesToTypes = map;
            this.setLookFurtherMode(false);
            this.setDirectedMode(true);
        }

        public ImmutableSet<BaseType> getDependentTypes() {
            return this.builder.build();
        }

        @Override
        public void preVisit(p p2, int n2) {
            this.builder.add((Object)this.nodesToTypes.get(p2));
        }
    }
}

