/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.Searchers.Text.Gui;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Gui.CSearchExecuter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Gui.CSearchInputField;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Gui.IGraphSearchFieldListener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Model.SearchResult;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.Searchers.Text.Model.GraphSearcher;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviEdge;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraphHelpers;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.comboboxes.memorybox.JMemoryBox;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public final class CGraphSearchField
extends JMemoryBox {
    private static final long serialVersionUID = 7655847738244119546L;
    private final ZyGraph m_graph;
    private final GraphSearcher m_searcher;
    private final JTextField m_textField = new CSearchInputField();
    private final ListenerProvider<IGraphSearchFieldListener> m_listenerProvider = new ListenerProvider();

    public CGraphSearchField(ZyGraph zyGraph) {
        super(20);
        Preconditions.checkNotNull(zyGraph, "IE01812: Target view can't be null");
        this.m_graph = zyGraph;
        this.m_searcher = new GraphSearcher();
        this.setEditor(new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                return CGraphSearchField.this.m_textField;
            }
        });
        this.registerHotkeys();
    }

    private String getText() {
        return ((JTextField)this.getEditor().getEditorComponent()).getText();
    }

    private void notifyListeners() {
        for (IGraphSearchFieldListener iGraphSearchFieldListener : this.m_listenerProvider) {
            iGraphSearchFieldListener.searched();
        }
    }

    private void registerHotkeys() {
        ActionMap actionMap = ((JTextField)this.getEditor().getEditorComponent()).getActionMap();
        InputMap inputMap = ((JTextField)this.getEditor().getEditorComponent()).getInputMap();
        this.setActionMap(actionMap);
        this.setInputMap(0, inputMap);
        inputMap.put(HotKeys.GRAPH_SEARCH_NEXT_KEY.getKeyStroke(), "NEXT");
        inputMap.put(HotKeys.GRAPH_SEARCH_NEXT_ZOOM_KEY.getKeyStroke(), "NEXT_ZOOM");
        inputMap.put(HotKeys.GRAPH_SEARCH_PREVIOUS_KEY.getKeyStroke(), "PREVIOUS");
        inputMap.put(HotKeys.GRAPH_SEARCH_PREVIOUS_ZOOM_KEY.getKeyStroke(), "PREVIOUS_ZOOM");
        actionMap.put("NEXT", CActionProxy.proxy(new CActionHotKey("NEXT")));
        actionMap.put("NEXT_ZOOM", CActionProxy.proxy(new CActionHotKey("NEXT_ZOOM")));
        actionMap.put("PREVIOUS", CActionProxy.proxy(new CActionHotKey("PREVIOUS")));
        actionMap.put("PREVIOUS_ZOOM", CActionProxy.proxy(new CActionHotKey("PREVIOUS_ZOOM")));
    }

    private void searchFor(String string2, boolean bl2, boolean bl3) {
        if (!"".equals(string2)) {
            this.add(string2);
        }
        CSearchExecuter.search(SwingUtilities.getWindowAncestor(this), this.getEditor(), this.m_graph, this.m_searcher, string2, bl2, bl3);
        this.notifyListeners();
    }

    public void addListener(IGraphSearchFieldListener iGraphSearchFieldListener) {
        this.m_listenerProvider.addListener(iGraphSearchFieldListener);
    }

    public void centerNextSearchHit(boolean bl2, boolean bl3) {
        String string2 = this.getText();
        if ("".equals(string2)) {
            this.m_searcher.clearResults();
            this.m_graph.updateGraphViews();
            this.notifyListeners();
            return;
        }
        this.searchFor(string2, bl2, bl3);
    }

    public void dispose() {
        this.m_searcher.dispose();
    }

    public GraphSearcher getGraphSearcher() {
        return this.m_searcher;
    }

    public void jumpTo(int n2) {
        this.m_searcher.getCursor().jumpTo(n2);
        SearchResult searchResult = this.m_searcher.getCursor().current();
        if (searchResult == null) {
            return;
        }
        if (searchResult.getObject() instanceof NaviNode) {
            ZyGraphHelpers.centerNode(this.m_graph, (NaviNode)searchResult.getObject(), false);
        } else if (searchResult.getObject() instanceof NaviEdge) {
            ZyGraphHelpers.centerEdgeLabel(this.m_graph, (NaviEdge)searchResult.getObject(), false);
        }
    }

    public void removeListener(IGraphSearchFieldListener iGraphSearchFieldListener) {
        this.m_listenerProvider.removeListener(iGraphSearchFieldListener);
    }

    public void searchFor(String string2) {
        this.setSelectedItem(string2);
        this.m_searcher.clearResults();
        this.searchFor(string2, false, false);
    }

    private final class CActionHotKey
    extends AbstractAction {
        private static final long serialVersionUID = -1618510363590582162L;
        private final String m_action;

        private CActionHotKey(String string2) {
            super(string2);
            this.m_action = string2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if ("NEXT".equals(this.m_action)) {
                CGraphSearchField.this.centerNextSearchHit(false, false);
            } else if ("NEXT_ZOOM".equals(this.m_action)) {
                CGraphSearchField.this.centerNextSearchHit(false, true);
            } else if ("PREVIOUS".equals(this.m_action)) {
                CGraphSearchField.this.centerNextSearchHit(true, false);
            } else if ("PREVIOUS_ZOOM".equals(this.m_action)) {
                CGraphSearchField.this.centerNextSearchHit(true, true);
            }
        }
    }
}

