/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.NodeChooser;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeChooser.CNodeChooserModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeChooser.CNodeChooserMouseListener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Searchers.Text.Gui.IGraphSearchFieldListener;
import com.google.security.zynamics.binnavi.Help.CHelpFunctions;
import com.google.security.zynamics.binnavi.Help.IHelpInformation;
import com.google.security.zynamics.binnavi.Help.IHelpProvider;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.ZyGraph.INaviGraphListener;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.CViewListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.NodeChooser.CNodeChooserRenderer;
import com.google.security.zynamics.binnavi.yfileswrap.Gui.GraphWindows.Searchers.Text.Gui.CGraphSearchField;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviEdge;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.general.comparators.IntComparator;
import com.google.security.zynamics.zylib.general.comparators.LexicalComparator;
import com.google.security.zynamics.zylib.gui.zygraph.IZyGraphSelectionListener;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.proximity.ZyProximityNode;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Collection;
import javax.swing.JTable;
import javax.swing.table.TableRowSorter;
import y.i.N;

public final class CNodeChooserTable
extends JTable
implements IHelpProvider {
    private static final long serialVersionUID = 8103057846466908170L;
    private final CNodeChooserModel m_model;
    private final CNodeChooserMouseListener m_mouselistener;
    private final InternalSearchFieldListener m_searchFieldListener = new InternalSearchFieldListener();
    private final InternalViewListener m_viewListener = new InternalViewListener();
    private final ZyGraph m_graph;
    private final CGraphSearchField m_searchField;

    public CNodeChooserTable(ZyGraph zyGraph, CGraphSearchField cGraphSearchField) {
        this.m_graph = Preconditions.checkNotNull(zyGraph, "IE01773: Graph argument can't be null.");
        this.m_searchField = Preconditions.checkNotNull(cGraphSearchField, "IE01774: Search field argument can not be null");
        this.m_model = new CNodeChooserModel(zyGraph);
        this.setModel(this.m_model);
        TableRowSorter<CNodeChooserModel> tableRowSorter = new TableRowSorter<CNodeChooserModel>(this.m_model);
        this.setRowSorter(tableRowSorter);
        tableRowSorter.setComparator(0, new IntComparator());
        tableRowSorter.setComparator(1, new IntComparator());
        tableRowSorter.setComparator(2, new LexicalComparator());
        tableRowSorter.setComparator(3, new IntComparator());
        CNodeChooserRenderer cNodeChooserRenderer = new CNodeChooserRenderer(this, this.m_graph, this.m_searchField.getGraphSearcher());
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(false);
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.getColumnModel().getColumn(0).setCellRenderer(cNodeChooserRenderer);
        this.getColumnModel().getColumn(1).setCellRenderer(cNodeChooserRenderer);
        this.getColumnModel().getColumn(2).setCellRenderer(cNodeChooserRenderer);
        this.getColumnModel().getColumn(3).setCellRenderer(cNodeChooserRenderer);
        this.getColumnModel().getColumn(0).setPreferredWidth(35);
        this.getColumnModel().getColumn(1).setPreferredWidth(35);
        this.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.getColumnModel().getColumn(0).setMaxWidth(50);
        this.getColumnModel().getColumn(1).setMaxWidth(50);
        this.getColumnModel().getColumn(3).setMaxWidth(50);
        this.m_searchField.addListener(this.m_searchFieldListener);
        this.m_mouselistener = new CNodeChooserMouseListener(this, zyGraph);
        this.addMouseListener(this.m_mouselistener);
        this.m_graph.addListener(this.m_viewListener);
        this.m_graph.addListener(this.m_viewListener);
        this.initializeViewListeners(this.m_graph.getRawView());
    }

    private void initializeViewListeners(INaviView iNaviView) {
        iNaviView.addListener(this.m_viewListener);
    }

    private void removeViewListeners(INaviView iNaviView) {
        iNaviView.removeListener(this.m_viewListener);
    }

    public void dispose() {
        this.removeMouseListener(this.m_mouselistener);
        this.m_searchField.removeListener(this.m_searchFieldListener);
        this.m_graph.removeListener(this.m_viewListener);
        this.m_graph.removeListener(this.m_viewListener);
        this.removeViewListeners(this.m_graph.getRawView());
    }

    @Override
    public IHelpInformation getHelpInformation() {
        return new IHelpInformation(){

            @Override
            public String getText() {
                return "The node chooser is used to select or deselect individual nodes of the graph.";
            }

            @Override
            public URL getUrl() {
                return CHelpFunctions.urlify("main_window.htm");
            }
        };
    }

    public int modelIndex(int n2) {
        return this.convertRowIndexToModel(n2);
    }

    private class InternalViewListener
    extends CViewListenerAdapter
    implements INaviGraphListener,
    IZyGraphSelectionListener {
        private InternalViewListener() {
        }

        @Override
        public void addedNode(INaviView iNaviView, INaviViewNode iNaviViewNode) {
            CNodeChooserTable.this.m_model.addNode(iNaviViewNode);
        }

        @Override
        public void edgeClicked(NaviEdge naviEdge, MouseEvent mouseEvent, double d2, double d3) {
        }

        @Override
        public void edgeLabelEntered(N n2, MouseEvent mouseEvent) {
        }

        @Override
        public void edgeLabelExited(N n2) {
        }

        @Override
        public void nodeClicked(NaviNode naviNode, MouseEvent mouseEvent, double d2, double d3) {
        }

        @Override
        public void nodeEntered(NaviNode naviNode, MouseEvent mouseEvent) {
        }

        @Override
        public void nodeHovered(NaviNode naviNode, double d2, double d3) {
        }

        @Override
        public void nodeLeft(NaviNode naviNode) {
        }

        @Override
        public void proximityBrowserNodeClicked(ZyProximityNode<?> zyProximityNode, MouseEvent mouseEvent, double d2, double d3) {
        }

        @Override
        public void addedNode(ZyGraph zyGraph, NaviNode naviNode) {
        }

        @Override
        public void changedModel(ZyGraph zyGraph, NaviNode naviNode) {
        }

        @Override
        public void untaggedNode(INaviView iNaviView, INaviViewNode iNaviViewNode, CTag cTag) {
        }

        @Override
        public void selectionChanged() {
        }

        @Override
        public void changedColor(INaviView iNaviView, IViewNode<?> iViewNode, Color color) {
            CNodeChooserTable.this.m_model.changedNode(iViewNode);
        }

        @Override
        public void changedSelection(INaviView iNaviView, IViewNode<?> iViewNode, boolean bl2) {
            CNodeChooserTable.this.m_model.changedNode(iViewNode);
        }

        @Override
        public void changedView(INaviView iNaviView, INaviView iNaviView2) {
            CNodeChooserTable.this.removeViewListeners(iNaviView);
            CNodeChooserTable.this.initializeViewListeners(iNaviView2);
        }

        @Override
        public void changedVisibility(INaviView iNaviView, IViewNode<?> iViewNode, boolean bl2) {
            CNodeChooserTable.this.m_model.changedNode(iViewNode);
        }

        @Override
        public void deletedNode(INaviView iNaviView, INaviViewNode iNaviViewNode) {
            CNodeChooserTable.this.m_model.deleteNode(iNaviViewNode);
        }

        @Override
        public void deletedNodes(INaviView iNaviView, Collection<INaviViewNode> collection) {
            CNodeChooserTable.this.m_model.deleteNodes(collection);
        }
    }

    private class InternalSearchFieldListener
    implements IGraphSearchFieldListener {
        private InternalSearchFieldListener() {
        }

        @Override
        public void searched() {
        }
    }
}

